/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ResourceBundle;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreePath;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.NbDialogOperator;
import org.netbeans.modules.visualweb.gravy.TreeTableOperator;
import org.netbeans.modules.visualweb.gravy.Util;

public class OptionsOperator
extends NbDialogOperator {
    public static final int PROJECT_LEVEL = 2;
    public static final int USER_LEVEL = 3;
    public static final int DEFAULT_LEVEL = 4;
    private static final long BEFORE_EDITING_TIMEOUT = 2000L;
    private static int DEFINE_HERE = 0;
    private JRadioButtonOperator _rbBasic;
    private JButtonOperator _btAdvanced;
    private JButtonOperator _btClose;
    private JButtonOperator _btHelp;
    private TreeTableOperator _treeTable;
    private static Operator.StringComparator oldComparator;

    public OptionsOperator() {
        super(OptionsOperator.getTitleToFind());
        this.setComparator(oldComparator);
        OptionsOperator.setDefaultStringComparator((Operator.StringComparator)oldComparator);
    }

    private static String getTitleToFind() {
        oldComparator = Operator.getDefaultStringComparator();
        Operator.DefaultStringComparator comparator = new Operator.DefaultStringComparator(true, true);
        OptionsOperator.setDefaultStringComparator((Operator.StringComparator)comparator);
        return Bundle.getString("org.netbeans.core.Bundle", "UI/Services");
    }

    public static OptionsOperator invoke() {
        Util.getMainMenu().pushMenu("Tools|Options");
        return new OptionsOperator();
    }

    public JRadioButtonOperator rbBasic() {
        if (this._rbBasic == null) {
            this._rbBasic = new JRadioButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("com.sun.rave.extension.core.actions.Bundle").getString("CTL_basic_button").trim());
        }
        return this._rbBasic;
    }

    public JButtonOperator rbAdvanced() {
        if (this._btAdvanced == null) {
            this._btAdvanced = new JButtonOperator((ContainerOperator)this, "Advanced Options");
        }
        return this._btAdvanced;
    }

    public JButtonOperator btClose() {
        if (this._btClose == null) {
            this._btClose = new JButtonOperator((ContainerOperator)this, Bundle.getStringTrimmed("org.netbeans.core.actions.Bundle", "CTL_close_button"));
        }
        return this._btClose;
    }

    public JButtonOperator btHelp() {
        if (this._btHelp == null) {
            this._btHelp = new JButtonOperator((ContainerOperator)this, "Help");
        }
        return this._btHelp;
    }

    public void basic() {
        this.rbBasic().push();
    }

    public void advanced() {
        this.rbAdvanced().push();
    }

    public void close() {
        this.btClose().pushNoBlock();
    }

    public void help() {
        this.btHelp().push();
    }

    public TreeTableOperator treeTable() {
        if (this._treeTable == null) {
            this._treeTable = new TreeTableOperator((ContainerOperator)this);
        }
        return this._treeTable;
    }

    public int selectOption(String optionPath) {
        TreePath path = this.treeTable().tree().findPath(optionPath, "|");
        if (!this.treeTable().tree().isPathSelected(path)) {
            this.treeTable().tree().selectPath(path);
        }
        int result = this.treeTable().tree().getRowForPath(path);
        this.treeTable().scrollToCell(result, 0);
        new EventTool().waitNoEvent(500L);
        return result;
    }

    public void showLevels() {
        if (this.treeTable().getColumnCount() == 2) {
            this.clickOnSecondHeader();
        }
    }

    public void hideLevels() {
        if (this.treeTable().getColumnCount() > 2) {
            this.clickOnSecondHeader();
        }
    }

    public int getLevel(String optionPath) {
        int row = this.selectOption(optionPath);
        if (this.getValue(row, 2) == DEFINE_HERE) {
            return 2;
        }
        if (this.getValue(row, 3) == DEFINE_HERE) {
            return 3;
        }
        if (this.getValue(row, 4) == DEFINE_HERE) {
            return 4;
        }
        return -1;
    }

    protected void setLevel(int row, int level) {
        if (level == 2) {
            this.defineHere(row, level);
        } else if (level == 3) {
            this.defineHere(row, level);
        } else if (level == 4) {
            this.revertLevel(row, level);
        }
    }

    protected int getValue(int row, int column) {
        return 0;
    }

    protected void revertLevel(int row, int colIndex) {
        this.editLevel(row, colIndex, Bundle.getString("org.netbeans.core.projects.Bundle", "LBL_action_revert"));
    }

    protected void defineHere(int row, int colIndex) {
        this.editLevel(row, colIndex, Bundle.getString("org.netbeans.core.projects.Bundle", "LBL_action_define"));
    }

    protected void editLevel(int rowIndex, int colIndex, String value) {
        this.treeTable().clickOnCell(rowIndex, colIndex);
        JComboBoxOperator combo = new JComboBoxOperator((ContainerOperator)this.treeTable());
        this.getTimeouts().sleep("OptionsOperator.BeforeEditingTimeout");
        combo.selectItem(value);
    }

    protected void clickOnSecondHeader() {
        JTableHeader header = this.treeTable().getTableHeader();
        Rectangle rect = header.getHeaderRect(1);
        new ComponentOperator((Component)header).clickMouse(rect.x + rect.width / 2, rect.y + rect.height / 2, 1);
    }

    public void verify() {
        this.btClose();
        this.btHelp();
        this.treeTable().verify();
    }

    static {
        Timeouts.initDefault((String)"OptionsOperator.BeforeEditingTimeout", (long)2000L);
    }
}

