/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.apitest;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.netbeans.apitest.Main;

public final class Sigtest
extends Task {
    File fileName;
    Path classpath;
    String version;
    String packages;
    ActionType action;
    boolean failOnError = true;

    public void setFileName(File f) {
        this.fileName = f;
    }

    public void setPackages(String s) {
        this.packages = s;
    }

    public void setAction(ActionType s) {
        this.action = s;
    }

    public void setClasspath(Path p) {
        if (this.classpath == null) {
            this.classpath = p;
        } else {
            this.classpath.append(p);
        }
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void execute() throws BuildException {
        int returnCode;
        if (this.fileName == null) {
            throw new BuildException("FileName has to filed", this.getLocation());
        }
        if (this.packages == null) {
            throw new BuildException("Packages has to filed", this.getLocation());
        }
        if (this.action == null) {
            throw new BuildException("Action has to filed", this.getLocation());
        }
        if (this.classpath == null) {
            throw new BuildException("Classpath has to filed", this.getLocation());
        }
        if (this.packages.equals("-")) {
            this.log("No public packages, skipping");
            return;
        }
        ArrayList<String> arg = new ArrayList<String>();
        arg.add("-FileName");
        arg.add(this.fileName.getAbsolutePath());
        if (this.action.getValue().equals("generate")) {
            arg.add("-setup");
        } else if (!this.action.getValue().equals("check")) {
            if (this.action.getValue().equals("binarycheck")) {
                arg.add("-extensibleinterfaces");
            } else if (this.action.getValue().equals("strictcheck")) {
                arg.add("-maintenance");
            } else {
                throw new BuildException("Unknown action: " + (Object)((Object)this.action));
            }
        }
        if (this.version != null) {
            arg.add("-Version");
            arg.add(this.version);
        }
        File outputFile = null;
        String s = this.getProject().getProperty("sigtest.output.dir");
        if (s != null) {
            File dir = this.getProject().resolveFile(s);
            dir.mkdirs();
            outputFile = new File(dir, this.fileName.getName().replace(".sig", "").replace("-", "."));
            this.log(outputFile.toString());
        }
        this.log("Packages: " + this.packages);
        StringTokenizer packagesTokenizer = new StringTokenizer(this.packages, ",");
        while (packagesTokenizer.hasMoreTokens()) {
            String p = packagesTokenizer.nextToken().trim();
            String prefix = "-PackageWithoutSubpackages ";
            int idx = p.lastIndexOf(".*");
            if (idx > 0) {
                p = p.substring(0, idx);
            } else {
                idx = p.lastIndexOf(".**");
                if (idx > 0) {
                    prefix = "-Package ";
                    p = p.substring(0, idx);
                }
            }
            arg.add(prefix.trim());
            arg.add(p);
        }
        if (this.classpath != null) {
            StringBuffer sb = new StringBuffer();
            String pref = "";
            for (String e : this.classpath.list()) {
                sb.append(pref);
                sb.append(e);
                pref = File.pathSeparator;
            }
            arg.add("-Classpath");
            arg.add(sb.toString());
        }
        if ((returnCode = Main.run(arg.toArray(new String[0])).getType()) != 0) {
            if (this.failOnError && outputFile == null) {
                throw new BuildException("Signature tests return code is wrong (" + returnCode + "), check the messages above", this.getLocation());
            }
            this.log("Signature tests return code is wrong (" + returnCode + "), check the messages above");
        } else if (outputFile != null) {
            outputFile.delete();
        }
    }

    public static final class ActionType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"generate", "check", "strictcheck", "binarycheck"};
        }
    }
}

