/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.others;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUCallGraphBuilder;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.FlatProfileBuilder;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerFree;
import org.netbeans.lib.profiler.tests.jfluid.CommonProfilerTestCase;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilerAppHandler;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilingPointsProcessor;
import org.netbeans.lib.profiler.tests.jfluid.utils.Utils;

public abstract class MeasureDiffsTestCase
extends CommonProfilerTestCase {
    static int ALL_INV_ERROR_METHOD = 0;
    static int LAST_INV_ERROR_METHOD = 1;
    File outFile;
    private CPUCallGraphBuilder builder;

    public MeasureDiffsTestCase(String name) {
        super(name);
    }

    public void startAppAlone(ProfilerEngineSettings settings) {
        ArrayList<String> commands = new ArrayList<String>(10);
        commands.add(settings.getTargetJVMExeFile());
        commands.add("-classpath");
        commands.add(settings.getMainClassPath());
        commands.add(settings.getMainClassName());
        commands.add(this.outFile.getAbsolutePath());
        String[] cmds = commands.toArray(new String[commands.size()]);
        try {
            Runtime.getRuntime().exec(cmds, null, new File(settings.getWorkingDir())).waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected ProfilerEngineSettings initCpuTest(String projectName, String mainClass) {
        ProfilerEngineSettings settings = this.initTest(projectName, mainClass, null);
        settings.setCPUProfilingType(0);
        settings.setInstrScheme(3);
        settings.setInstrumentEmptyMethods(false);
        settings.setInstrumentGetterSetterMethods(false);
        settings.setInstrumentMethodInvoke(true);
        settings.setInstrumentSpawnedThreads(true);
        settings.setExcludeWaitTime(true);
        settings.setThreadCPUTimerOn(false);
        return settings;
    }

    protected ProfilerEngineSettings initCpuTest(String projectName, String mainClass, String[][] rootMethods) {
        ProfilerEngineSettings settings = this.initTest(projectName, mainClass, rootMethods);
        settings.setCPUProfilingType(0);
        settings.setInstrScheme(1);
        settings.setInstrumentEmptyMethods(false);
        settings.setInstrumentGetterSetterMethods(false);
        settings.setInstrumentMethodInvoke(true);
        settings.setInstrumentSpawnedThreads(false);
        settings.setExcludeWaitTime(true);
        settings.setThreadCPUTimerOn(false);
        return settings;
    }

    protected void readIdealTimes(HashMap results) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.outFile));
            boolean first = true;
            while ((line = br.readLine()) != null) {
                if (first) {
                    first = false;
                    continue;
                }
                StringTokenizer st = new StringTokenizer(line, ";");
                String met = st.nextToken();
                Results res = new Results();
                res.setIdeal(st.nextToken());
                res.setMeasuredAlone(st.nextToken());
                results.put(met, res);
            }
            br.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void readProfiledTimes(HashMap results) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.outFile));
            boolean first = true;
            while ((line = br.readLine()) != null) {
                if (first) {
                    first = false;
                    continue;
                }
                StringTokenizer st = new StringTokenizer(line, ";");
                String met = st.nextToken();
                st.nextToken();
                Results res = (Results)results.get(met);
                if (res == null) continue;
                res.setMeasuredProfiled(st.nextToken());
            }
            br.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void refCPUResults(FlatProfileContainer fpc, String[] methodsOrder, HashMap results) {
        for (int row = 0; row < fpc.getNRows(); ++row) {
            for (int mets = 0; mets < methodsOrder.length; ++mets) {
                Results res;
                if (!fpc.getMethodNameAtRow(row).startsWith(methodsOrder[mets])) continue;
                double tm = (double)fpc.getTimeInMcs0AtRow(row) / ((double)fpc.getNInvocationsAtRow(row) * 1000.0);
                String name = fpc.getMethodNameAtRow(row);
                if (name.indexOf(46) > -1) {
                    name = name.substring(name.lastIndexOf(46) + 1);
                }
                if ((res = (Results)results.get(name = name.substring(0, name.indexOf(40)))) == null) continue;
                res.setProfiled(tm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startCPUTest(ProfilerEngineSettings settings, String[] methodsOrder) {
        HashMap results = new HashMap(64);
        MeasureDiffsTestCase.assertTrue((this.builder != null ? 1 : 0) != 0);
        try {
            this.outFile = File.createTempFile("profiler", "test");
            this.startAppAlone(settings);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.readIdealTimes(results);
        settings.setMainArgs(this.outFile.getAbsolutePath());
        TargetAppRunner runner = new TargetAppRunner(settings, (AppStatusHandler)new TestProfilerAppHandler(this), (ProfilingPointsProcessor)new TestProfilingPointsProcessor());
        runner.addProfilingEventListener(Utils.createProfilingListener(this));
        ProfilingResultsDispatcher.getDefault().addListener((CPUProfilingResultListener)this.builder);
        CPUResultListener resultListener = new CPUResultListener();
        this.builder.addListener((CCTProvider.Listener)resultListener);
        FlatProfileBuilder flattener = new FlatProfileBuilder();
        this.builder.addListener((CCTProvider.Listener)flattener);
        flattener.setContext(runner.getProfilerClient());
        try {
            runner.readSavedCalibrationData();
            Process p = this.startTargetVM(runner);
            MeasureDiffsTestCase.assertNotNull((String)"Target JVM is not started", (Object)p);
            this.bindStreams(p);
            runner.connectToStartedVMAndStartTA();
            runner.getProfilerClient().initiateRecursiveCPUProfInstrumentation(settings.getInstrumentationRootMethods());
            this.waitForStatus(1);
            MeasureDiffsTestCase.assertTrue((String)"runner is not running", (boolean)runner.targetAppIsRunning());
            ArrayList methods = new ArrayList();
            this.waitForStatus(4);
            if (runner.targetJVMIsAlive()) {
                this.log("Get results: " + System.currentTimeMillis());
                MeasureDiffsTestCase.assertTrue((String)"Results do not exist - issue 65185.", (boolean)runner.getProfilerClient().cpuResultsExist());
                runner.getProfilerClient().forceObtainedResultsDump();
                boolean gotResults = resultListener.wait4results(10000L);
                MeasureDiffsTestCase.assertTrue((String)"Results are not available after 10 seconds.", (boolean)gotResults);
                this.log("obtaining results " + String.valueOf(System.currentTimeMillis()));
                FlatProfileContainerFree fpc = (FlatProfileContainerFree)flattener.createFlatProfile();
                fpc.filterOriginalData(new String[0], 0, 0.0);
                this.refCPUResults((FlatProfileContainer)fpc, methodsOrder, results);
            }
            this.setStatus(8);
            this.readProfiledTimes(results);
            this.writeResults(results);
        }
        catch (Exception ex) {
            this.log(ex);
            MeasureDiffsTestCase.assertTrue((String)("Exception thrown: " + ex.getMessage()), (boolean)false);
        }
        finally {
            this.finalizeTest(runner);
        }
    }

    protected void writeResults(HashMap results) {
        Object[] keys = results.keySet().toArray();
        Arrays.sort(keys);
        this.log("\nMethod Name;Ideal Time;Measured Time;Measured during profiling;Measured by profiler");
        for (int i = 0; i < keys.length; ++i) {
            Results res = (Results)results.get(keys[i]);
            this.log(keys[i] + ";" + res.toString());
        }
        this.log("\n");
    }

    private static class CPUResultListener
    implements CPUCCTProvider.Listener {
        private final Object resultsLock = new Object();
        private boolean hasResults = false;

        private CPUResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cctEstablished(RuntimeCCTNode appRootNode) {
            Object object = this.resultsLock;
            synchronized (object) {
                this.hasResults = true;
                this.resultsLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cctReset() {
            Object object = this.resultsLock;
            synchronized (object) {
                this.hasResults = false;
                this.resultsLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean wait4results(long timeout) {
            Object object = this.resultsLock;
            synchronized (object) {
                if (!this.hasResults) {
                    try {
                        this.resultsLock.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                return this.hasResults;
            }
        }
    }

    class Results {
        double ideal;
        double measalone;
        double measprofiler;
        double profiled;

        Results() {
        }

        public void setIdeal(String val) {
            try {
                this.ideal = Double.parseDouble(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void setMeasuredAlone(String val) {
            try {
                this.measalone = Double.parseDouble(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void setMeasuredProfiled(String val) {
            try {
                this.measprofiler = Double.parseDouble(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void setProfiled(double val) {
            this.profiled = val;
        }

        public String toString() {
            return String.valueOf(this.ideal) + ";" + String.valueOf(this.measalone) + ";" + String.valueOf(this.measprofiler) + ";" + String.valueOf(this.profiled);
        }
    }
}

