/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.diff.LineDiff;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.tests.jfluid.utils.DumpStream;
import org.netbeans.lib.profiler.utils.MiscUtils;

public abstract class CommonProfilerTestCase
extends NbTestCase {
    public static final int STATUS_ERROR = 255;
    public static final int STATUS_NONE = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_RESULTS_AVAILABLE = 2;
    public static final int STATUS_APP_FINISHED = 4;
    public static final int STATUS_MEASURED = 8;
    public static final int STATUS_FINISHED = 16;
    public static final int STATUS_LIVERESULTS_AVAILABLE = 32;
    private static final boolean CREATE_GOLDENS = false;
    private static final String GOLDENS_CVS_PATH = "/space/cvs/profiler/profiler/libs/jfluid/test/functional/data/goldenfiles";
    protected DumpStream err;
    protected DumpStream out;
    protected File diff;
    protected File ref;
    protected Process profilingProcess = null;
    PrintStream goldenStream;
    PrintStream logStream;
    PrintStream refStream;
    private String mainClass;
    private String projectName;
    private String[][] rootMethods;
    private int status = 0;

    public CommonProfilerTestCase(String name) {
        super(name);
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setRootMethods(String[][] rootMethods) {
        this.rootMethods = rootMethods;
    }

    public String[][] getRootMethods() {
        return this.rootMethods;
    }

    public synchronized void setStatus(int status) {
        this.log("STATUS: set status " + this.getStatus(status));
        System.err.println("STATUS: set status " + this.getStatus(status));
        if (255 == status) {
            new Exception("STATUS_ERROR set").printStackTrace();
        }
        this.status |= status;
        ((Object)((Object)this)).notifyAll();
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatus(int status) {
        StringBuffer sb = new StringBuffer();
        if (status == 255) {
            sb.append("ERROR");
        } else {
            if ((status & 4) > 0) {
                sb.append("APP_FINISHED ");
            }
            if ((status & 0x10) > 0) {
                sb.append("FINISHED ");
            }
            if ((status & 8) > 0) {
                sb.append("MEASURED ");
            }
            if (status == 0) {
                sb.append("NONE ");
            }
            if ((status & 2) > 0) {
                sb.append("RESULTS_AVAILABLE ");
            }
            if ((status & 1) > 0) {
                sb.append("RUNNING ");
            }
            if ((status & 0x20) > 0) {
                sb.append("LIVERESULTS_AVAILABLE ");
            }
        }
        return sb.toString();
    }

    public boolean isStatus(int status) {
        if (status == 255) {
            return this.getStatus() == status;
        }
        return (this.getStatus() & status) > 0;
    }

    public void log(Throwable t) {
        t.printStackTrace(this.getLogStream());
    }

    public void log(String s) {
        this.getLogStream().println(s);
    }

    public void log(Object o) {
        this.log(o.toString());
    }

    public void log(double[] ar) {
        StringBuffer sb = new StringBuffer(ar.length * 10);
        sb.append("[");
        for (int i = 0; i < ar.length; ++i) {
            sb.append(String.valueOf(ar[i]));
            if (i >= ar.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        this.log(sb.toString());
    }

    public void log(int[] ar) {
        StringBuffer sb = new StringBuffer(ar.length * 10);
        sb.append("[");
        for (int i = 0; i < ar.length; ++i) {
            sb.append(String.valueOf(ar[i]));
            if (i >= ar.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        this.log(sb.toString());
    }

    public void log(HashMap map) {
        Object[] keys = map.keySet().toArray();
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            this.log((String)keys[i] + " = " + (String)map.get(keys[i]));
        }
    }

    public void log(ProfilerEngineSettings settings) {
        HashMap map = new HashMap(32);
        this.storeSettings(settings, map);
        this.log(map);
    }

    public void ref(String s) {
        this.getRefStream().println(s);
    }

    public void ref(String[] s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i]);
            if (i >= s.length - 1) continue;
            sb.append(", ");
        }
        this.ref(sb);
    }

    public void ref(Object o) {
        this.ref(o.toString());
    }

    public void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable td) {
            td.printStackTrace();
            if (!this.isStatus(255)) {
                this.setStatus(255);
            }
            throw td;
        }
    }

    public synchronized void unsetStatus(int status) {
        if (status != 255) {
            this.log("STATUS: unset status " + this.getStatus(status));
            System.err.println("STATUS: unset status " + this.getStatus(status));
            this.status &= ~status;
            ((Object)((Object)this)).notifyAll();
        }
    }

    public void waitForStatus(int status) {
        this.waitForStatus(status, 0L);
    }

    public synchronized void waitForStatus(int status, long timeout) {
        this.log("STATUS: wait for status " + this.getStatus(status));
        System.err.println("STATUS: wait for status " + this.getStatus(status));
        while (!this.isStatus(status) && !this.isStatus(255)) {
            try {
                ((Object)((Object)this)).wait(timeout);
            }
            catch (InterruptedException e) {}
        }
        this.log("STATUS: reached status " + this.getStatus(this.getStatus()));
        System.err.println("STATUS: reached status " + this.getStatus(this.getStatus()));
        if (this.isStatus(255)) {
            CommonProfilerTestCase.assertTrue((String)"Error state of test", (boolean)false);
        }
    }

    protected void setClassPath(ProfilerEngineSettings settings) {
        String projPath = this.getProjectPath(this.getProjectName());
        settings.setMainClassPath(projPath);
        settings.setMainClass(this.getMainClass());
        ClassRepository.initClassPaths((String)this.getDataDir().getAbsolutePath(), (String[])new String[]{projPath, "", ""});
    }

    protected PrintStream getLogStream() {
        if (this.logStream == null) {
            this.logStream = this.getLog();
        }
        return this.logStream;
    }

    protected void setProfilerHome(ProfilerEngineSettings settings) {
        try {
            String profilerHome = System.getProperty("profiler.home");
            if (profilerHome == null || !new File(profilerHome).exists()) {
                profilerHome = "/space/Builds/profiler/profiler2";
            }
            settings.initialize(profilerHome + "/lib");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            CommonProfilerTestCase.assertFalse((String)"Error in initialization", (boolean)true);
        }
    }

    protected String getProjectPath(String projectName) {
        String jarPath = "/projects/" + projectName + "/distrib/" + projectName + ".jar";
        if (!new File(this.getDataDir(), jarPath).exists()) {
            jarPath = "/projects/" + projectName + "/dist/" + projectName + ".jar";
        }
        if (!new File(this.getDataDir(), jarPath).exists()) {
            CommonProfilerTestCase.assertTrue((String)"There is not profiled application", (boolean)false);
            return "";
        }
        String xData = this.getDataDir().getAbsolutePath();
        return xData + jarPath;
    }

    protected PrintStream getRefStream() {
        if (this.refStream == null) {
            this.refStream = this.getRef();
        }
        return this.refStream;
    }

    protected void setRootMethods(ProfilerEngineSettings settings, String[][] rootMethods) {
        this.rootMethods = rootMethods;
        if (rootMethods == null) {
            this.rootMethods = new String[][]{{this.mainClass, "main", "([Ljava/lang/String;)V"}};
        }
        ArrayList<ClientUtils.SourceCodeSelection> al = new ArrayList<ClientUtils.SourceCodeSelection>();
        for (int i = 0; i < this.rootMethods.length; ++i) {
            al.add(new ClientUtils.SourceCodeSelection(this.rootMethods[i][0], this.rootMethods[i][1], this.rootMethods[i][2]));
        }
        settings.setInstrumentationRootMethods(al.toArray(new ClientUtils.SourceCodeSelection[al.size()]));
    }

    protected void setTargetVM(ProfilerEngineSettings settings) {
        String vers = System.getProperty("java.vm.version");
        if (vers.startsWith("1.5")) {
            if (vers.startsWith("1.5.0") && (vers.charAt("1.5.0".length()) != '_' || Integer.parseInt(vers.substring("1.5.0".length() + 1, "1.5.0".length() + 3)) < 4)) {
                System.err.println("Illegal version of JVM: " + vers);
                return;
            }
            settings.setTargetJDKVersionString("jdk15");
        } else if (vers.startsWith("1.6")) {
            settings.setTargetJDKVersionString("jdk16");
        } else if (vers.startsWith("1.7")) {
            settings.setTargetJDKVersionString("jdk17");
        }
        String home = System.getProperty("java.home");
        if (File.separatorChar == '/') {
            settings.setTargetJVMExeFile(home + "/bin/java");
        } else {
            settings.setTargetJVMExeFile(home + "\\bin\\java.exe");
        }
        settings.setSystemArchitecture(Platform.getSystemArchitecture());
    }

    protected void setUp() throws Exception {
        System.err.println("START TEST " + ((Object)((Object)this)).getClass().getName() + "." + this.getName());
        File workdir = this.getWorkDir();
        this.diff = new File(this.getWorkDir(), this.getName() + ".diff");
        this.ref = new File(this.getWorkDir(), this.getName() + ".ref");
        this.log("Test Source: http://toolscvs.sfbay.sun.com/cvsweb/profiler/libs/jfluid/test/functional/src/" + ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".java?cvsroot=/cvs/profiler");
        try {
            Socket sock = new Socket("localhost", 5140);
            sock.getOutputStream().write(1);
            sock.close();
            CommonProfilerTestCase.assertTrue((String)"There is running another server on port 5140", (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addJVMArgs(ProfilerEngineSettings settings, String arg) {
        String old = settings.getJVMArgsAsSingleString();
        if (old == null || old.length() == 0) {
            settings.setJVMArgs(arg);
        } else {
            settings.setJVMArgs(old + " " + arg);
        }
    }

    protected void bindStreams(Process p) {
        this.err = new DumpStream(p, p.getErrorStream(), this.getLogStream(), "[App error] ");
        this.err.start();
        this.out = new DumpStream(p, p.getInputStream(), this.getLogStream(), "[App output] ");
        this.out.start();
    }

    protected String complete(String s, int chars) {
        StringBuffer sb = new StringBuffer(chars);
        int tot = chars - s.length();
        sb.append(s);
        for (int i = 0; i < tot; ++i) {
            sb.append(" ");
        }
        return sb.substring(0, chars);
    }

    protected void finalizeTest(TargetAppRunner runner) {
        if (!this.isStatus(8)) {
            System.err.println("must be set measured");
            this.setStatus(8);
        }
        if (!this.isStatus(4)) {
            System.err.println("must be treminated target vm");
            runner.terminateTargetJVM();
        }
        int cycles = 50;
        while (cycles > 0 && runner.targetJVMIsAlive()) {
            try {
                Thread.sleep(500L);
                --cycles;
            }
            catch (InterruptedException ex) {}
        }
        CommonProfilerTestCase.assertFalse((String)"Target JVM is running after finish", (boolean)runner.targetJVMIsAlive());
        if (this.profilingProcess != null) {
            try {
                this.profilingProcess.waitFor();
                if (this.out != null) {
                    this.out.join();
                    this.err.join();
                }
                this.profilingProcess.destroy();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            this.profilingProcess = null;
        }
        this.log("\nProfiler settings\n");
        this.log(runner.getProfilerEngineSettings());
        this.log("");
        System.err.println("Test " + this.getName() + " finalized.");
    }

    protected void initAppByStream(TargetAppRunner runner) {
        Process p = runner.getRunningAppProcess();
        assert (p != null);
        try {
            PrintStream ps = new PrintStream(p.getOutputStream());
            ps.print("start");
            ps.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ProfilerEngineSettings initTest(String projectName, String mainClass, String[][] rootMethods) {
        ProfilerEngineSettings settings = new ProfilerEngineSettings();
        settings.setPortNo(5140);
        settings.setSeparateConsole(true);
        settings.setInstrScheme(3);
        settings.setJVMArgs("");
        this.setProjectName(projectName);
        this.setMainClass(mainClass);
        this.setRootMethods(settings, rootMethods);
        this.setTargetVM(settings);
        this.setClassPath(settings);
        this.setProfilerHome(settings);
        this.setStatus(0);
        return settings;
    }

    protected Process startTargetVM(TargetAppRunner runner) {
        int i;
        ProfilerEngineSettings settings = runner.getProfilerEngineSettings();
        AppStatusHandler handler = runner.getAppStatusHandler();
        ArrayList<String> commands = new ArrayList<String>(10);
        commands.add(settings.getTargetJVMExeFile());
        String jfNativeLibFullName = Platform.getAgentNativeLibFullName((String)settings.getJFluidRootDirName(), (boolean)false, (String)settings.getTargetJDKVersionString(), (int)-1);
        String libpath = jfNativeLibFullName.substring(0, jfNativeLibFullName.indexOf("deployed") - 1);
        String timeOut = System.getProperty("profiler.agent.connect.timeout", "10");
        commands.add("-agentpath:" + jfNativeLibFullName + "=" + libpath + "," + Integer.toString(settings.getPortNo()) + "," + timeOut);
        if (!Platform.isWindows() && settings.getTargetWindowRemains()) {
            commands.add("-XX:+ShowMessageBoxOnError");
        }
        commands.add("-classpath");
        commands.add(settings.getMainClassPath());
        for (i = 0; i < settings.getJVMArgs().length; ++i) {
            commands.add(settings.getJVMArgs()[i]);
        }
        if (System.getProperty("org.netbeans.lib.profiler.wireprotocol.WireIO.agent") != null) {
            commands.add("-Dorg.netbeans.lib.profiler.wireprotocol.WireIO=true");
        }
        if (System.getProperty("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook") != null) {
            commands.add("-Dorg.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook=true");
        }
        commands.add(settings.getMainClassName());
        for (i = 0; i < settings.getMainArgs().length; ++i) {
            commands.add(settings.getMainArgs()[i]);
        }
        String[] cmdArray = new String[commands.size()];
        commands.toArray(cmdArray);
        MiscUtils.printInfoMessage((String)"Starting target application...");
        MiscUtils.printVerboseInfoMessage((String[])cmdArray);
        System.err.println("Starting VM with " + cmdArray.length + " commands.");
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < cmdArray.length; ++i2) {
            sb.append(cmdArray[i2]);
            sb.append(' ');
        }
        System.err.println(sb.toString());
        try {
            this.profilingProcess = Runtime.getRuntime().exec(cmdArray, null, new File(settings.getWorkingDir()));
            if (this.profilingProcess == null) {
                throw new NullPointerException();
            }
            runner.initiateSession(0, false);
            return this.profilingProcess;
        }
        catch (IOException ex) {
            String s = "";
            for (int i3 = 0; i3 < cmdArray.length; ++i3) {
                s = s + cmdArray[i3] + "\n";
            }
            handler.displayError("When starting target JVM, with command: " + s + ", caught an exception: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    protected void storeSettings(ProfilerEngineSettings settings, HashMap map) {
        map.put("profiler.settings.cpu.profiling.type", settings.getCPUProfilingType() == 0 ? "CPU_INSTR_FULL" : "CPU_INSTR_SAMPLED");
        if (settings.getInstrScheme() == 1) {
            map.put("profiler.settings.instr.scheme", "INSTRSCHEME_LAZY");
        } else if (settings.getInstrScheme() == 2) {
            map.put("profiler.settings.instr.scheme", "INSTRSCHEME_EAGER");
        } else {
            map.put("profiler.settings.instr.scheme", "INSTRSCHEME_TOTAL");
        }
        map.put("profiler.settings.override.working.dir", settings.getWorkingDir());
        map.put("profiler.settings.override.jvm.args", this.toString(settings.getJVMArgs()));
        map.put("profiler.settings.override.port.no", Integer.toString(settings.getPortNo()));
        map.put("profiler.settings.thread.cpu.timer.on", Boolean.toString(settings.getThreadCPUTimerOn()));
        map.put("profiler.settings.istrument.getter.setter.methods", Boolean.toString(settings.getInstrumentGetterSetterMethods()));
        map.put("profiler.settings.instrument.empty.methods", Boolean.toString(settings.getInstrumentEmptyMethods()));
        map.put("profiler.settings.instrument.method.invoke", Boolean.toString(settings.getInstrumentMethodInvoke()));
        map.put("profiler.settings.instrument.spawned.threads", Boolean.toString(settings.getInstrumentSpawnedThreads()));
        map.put("profiler.settings.n.profiled.threads.limit", Integer.toString(settings.getNProfiledThreadsLimit()));
        map.put("profiler.settings.sort.results.by.thread.cpu.time", Boolean.toString(settings.getSortResultsByThreadCPUTime()));
        map.put("profiler.settings.sampling.interval", Integer.toString(settings.getSamplingInterval()));
        map.put("profiler.settings.code.region.cpu.res.buf.size", Integer.toString(settings.getCodeRegionCPUResBufSize()));
        map.put("profiler.settings.run.gc.on.get.results.in.memory.profiling", Boolean.toString(settings.getRunGCOnGetResultsInMemoryProfiling()));
        map.put("profiler.settings.obj.alloc.stack.sampling.interval", Integer.toString(settings.getAllocTrackEvery()));
        map.put("profiler.settings.obj.alloc.stack.sampling.depth", Integer.toString(settings.getAllocStackTraceLimit()));
        map.put("profiler.settings.exclude.wait.time", Boolean.toString(settings.getExcludeWaitTime()));
        InstrumentationFilter filter = settings.getInstrumentationFilter();
        if (filter != null) {
            map.put("profiler.settings.instrumentation.filter.string", this.toString(filter.getFilterStrings()));
            map.put("profiler.settings.instrumentation.filter.type", filter.getFilterType() == 10 ? "EXCLUSIVE" : "INCLUSIVE");
        } else {
            map.put("profiler.settings.instrumentation.filter.selected", "NONE");
        }
        ClientUtils.SourceCodeSelection[] roots = settings.getInstrumentationRootMethods();
        if (roots != null && roots.length > 0) {
            map.put("profiler.settings.instrumentation.root.methods.size", Integer.toString(roots.length));
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < roots.length; ++i) {
                if (roots[i].getStartLine() > -1) {
                    sb.append(roots[i].getClassName());
                    sb.append("[");
                    sb.append(roots[i].getStartLine());
                    sb.append(", ");
                    sb.append(roots[i].getEndLine());
                    sb.append("]");
                } else {
                    sb.append(roots[i].getClassName());
                    sb.append(".");
                    sb.append(roots[i].getMethodName());
                    sb.append(roots[i].getMethodSignature());
                }
                if (i >= roots.length - 1) continue;
                sb.append(", ");
            }
            map.put("profiler.settings.istrumentation.root.methods-", sb.toString());
        } else {
            map.put("profiler.settings.instrumentation.root.methods.size", "0");
            map.put("profiler.settings.istrumentation.root.methods-", "");
        }
    }

    protected void tearDown() throws Exception {
        if (this.refStream != null) {
            this.refStream.close();
            boolean bgolden = true;
            try {
                this.getGoldenFile();
            }
            catch (Throwable t) {
                bgolden = false;
            }
            if ((bgolden || this.ref.length() > 0L) && !this.isStatus(255)) {
                LineDiff ld = new LineDiff();
                CommonProfilerTestCase.assertFalse((String)"Golden files differ", (boolean)ld.diff(this.ref, this.getGoldenFile(), this.diff));
            }
        }
        if (this.logStream != null) {
            this.logStream.close();
        }
        System.err.println("Test " + this.getName() + " finished.");
    }

    protected String toString(String[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            sb.append(" ");
        }
        return sb.toString();
    }

    protected String toString(int[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            sb.append(" ");
        }
        return sb.toString();
    }
}

