/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beans.Version;

public class HttpListener
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    private static final Version runtimeVersion = new Version(4, 2, 0);
    public static final String SSL = "Ssl";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public HttpListener() {
        this(1);
    }

    public HttpListener(int options) {
        super(comparators, runtimeVersion);
        this.initPropertyTables(2);
        this.createProperty("ssl", SSL, 66064, Ssl.class);
        this.createAttribute(SSL, "cert-nickname", "CertNickname", 257, null, null);
        this.createAttribute(SSL, "ssl2-enabled", "Ssl2Enabled", 1, null, "false");
        this.createAttribute(SSL, "ssl2-ciphers", "Ssl2Ciphers", 513, null, null);
        this.createAttribute(SSL, "ssl3-enabled", "Ssl3Enabled", 1, null, "true");
        this.createAttribute(SSL, "ssl3-tls-ciphers", "Ssl3TlsCiphers", 513, null, null);
        this.createAttribute(SSL, "tls-enabled", "TlsEnabled", 1, null, "true");
        this.createAttribute(SSL, "tls-rollback-enabled", "TlsRollbackEnabled", 1, null, "true");
        this.createAttribute(SSL, "client-auth-enabled", "ClientAuthEnabled", 1, null, "false");
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setSsl(Ssl value) {
        this.setValue(SSL, value);
    }

    public Ssl getSsl() {
        return (Ssl)this.getValue(SSL);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(HttpListener.class).getString("cannotAddDuplicate", (Object)ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getId() {
        return this.getAttributeValue("id");
    }

    public void setId(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("id", v, overwrite);
    }

    public void setId(String v) {
        this.setAttributeValue("id", v);
    }

    public String getAddress() {
        return this.getAttributeValue("address");
    }

    public void setAddress(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("address", v, overwrite);
    }

    public void setAddress(String v) {
        this.setAttributeValue("address", v);
    }

    public String getPort() {
        return this.getAttributeValue("port");
    }

    public void setPort(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("port", v, overwrite);
    }

    public void setPort(String v) {
        this.setAttributeValue("port", v);
    }

    public String getExternalPort() {
        return this.getAttributeValue("external-port");
    }

    public void setExternalPort(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("external-port", v, overwrite);
    }

    public void setExternalPort(String v) {
        this.setAttributeValue("external-port", v);
    }

    public String getFamily() {
        return this.getAttributeValue("family");
    }

    public void setFamily(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("family", v, overwrite);
    }

    public void setFamily(String v) {
        this.setAttributeValue("family", v);
    }

    public static String getDefaultFamily() {
        return "inet".trim();
    }

    public boolean isBlockingEnabled() {
        return HttpListener.toBoolean(this.getAttributeValue("blocking-enabled"));
    }

    public void setBlockingEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("blocking-enabled", "" + v, overwrite);
    }

    public void setBlockingEnabled(boolean v) {
        this.setAttributeValue("blocking-enabled", "" + v);
    }

    public static String getDefaultBlockingEnabled() {
        return "false".trim();
    }

    public String getAcceptorThreads() {
        return this.getAttributeValue("acceptor-threads");
    }

    public void setAcceptorThreads(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("acceptor-threads", v, overwrite);
    }

    public void setAcceptorThreads(String v) {
        this.setAttributeValue("acceptor-threads", v);
    }

    public static String getDefaultAcceptorThreads() {
        return "1".trim();
    }

    public boolean isSecurityEnabled() {
        return HttpListener.toBoolean(this.getAttributeValue("security-enabled"));
    }

    public void setSecurityEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("security-enabled", "" + v, overwrite);
    }

    public void setSecurityEnabled(boolean v) {
        this.setAttributeValue("security-enabled", "" + v);
    }

    public static String getDefaultSecurityEnabled() {
        return "false".trim();
    }

    public String getDefaultVirtualServer() {
        return this.getAttributeValue("default-virtual-server");
    }

    public void setDefaultVirtualServer(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("default-virtual-server", v, overwrite);
    }

    public void setDefaultVirtualServer(String v) {
        this.setAttributeValue("default-virtual-server", v);
    }

    public String getServerName() {
        return this.getAttributeValue("server-name");
    }

    public void setServerName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("server-name", v, overwrite);
    }

    public void setServerName(String v) {
        this.setAttributeValue("server-name", v);
    }

    public String getRedirectPort() {
        return this.getAttributeValue("redirect-port");
    }

    public void setRedirectPort(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("redirect-port", v, overwrite);
    }

    public void setRedirectPort(String v) {
        this.setAttributeValue("redirect-port", v);
    }

    public boolean isXpoweredBy() {
        return HttpListener.toBoolean(this.getAttributeValue("xpowered-by"));
    }

    public void setXpoweredBy(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("xpowered-by", "" + v, overwrite);
    }

    public void setXpoweredBy(boolean v) {
        this.setAttributeValue("xpowered-by", "" + v);
    }

    public static String getDefaultXpoweredBy() {
        return "true".trim();
    }

    public boolean isEnabled() {
        return HttpListener.toBoolean(this.getAttributeValue("enabled"));
    }

    public void setEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("enabled", "" + v, overwrite);
    }

    public void setEnabled(boolean v) {
        this.setAttributeValue("enabled", "" + v);
    }

    public static String getDefaultEnabled() {
        return "true".trim();
    }

    public Ssl newSsl() {
        return new Ssl();
    }

    public ElementProperty newElementProperty() {
        return new ElementProperty();
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "http-listener" + (this.canHaveSiblings() ? "[@id='" + this.getAttributeValue("id") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals("family")) {
            return "inet".trim();
        }
        if (attr.equals("blocking-enabled")) {
            return "false".trim();
        }
        if (attr.equals("acceptor-threads")) {
            return "1".trim();
        }
        if (attr.equals("security-enabled")) {
            return "false".trim();
        }
        if (attr.equals("xpowered-by")) {
            return "true".trim();
        }
        if (attr.equals("enabled")) {
            return "true".trim();
        }
        return null;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public void validate() throws ValidateException {
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(SSL);
        Ssl n = this.getSsl();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(SSL, 0, str, indent);
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("HttpListener\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

