/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev.gen;

import java.io.IOException;
import java.util.Stack;
import org.netbeans.modules.schema2beansdev.gen.IndentingWriter;

public class XMLWriter
extends IndentingWriter {
    protected String xmlVersion = "1.0";
    protected String encoding = "UTF-8";
    protected boolean header = true;
    protected Stack tags;
    public int HEADER_SECTION = 0;
    public int BODY_SECTION = 1;
    protected static final int defaultSectionCount = 2;

    public XMLWriter() {
        super(2);
        this.privateInit();
    }

    public XMLWriter(boolean header) {
        super(2);
        this.header = header;
        this.privateInit();
    }

    public XMLWriter(String encoding) {
        super(2);
        this.encoding = encoding;
        this.privateInit();
    }

    public XMLWriter(String encoding, String xmlVersion) {
        super(2);
        this.encoding = encoding;
        this.xmlVersion = xmlVersion;
        this.privateInit();
    }

    public int insertSectionAfter(int sectionNum) {
        this.insertAdditionalBuffers(sectionNum, 1);
        if (sectionNum < this.HEADER_SECTION) {
            ++this.HEADER_SECTION;
        }
        if (sectionNum < this.BODY_SECTION) {
            ++this.BODY_SECTION;
        }
        return sectionNum + 1;
    }

    public void reset() {
        super.reset();
        this.privateInit();
    }

    private void privateInit() {
        this.tags = new Stack();
        try {
            if (this.header) {
                this.select(this.HEADER_SECTION);
                this.write("<?xml version='");
                this.write(this.xmlVersion);
                this.write("' encoding='");
                this.write(this.encoding);
                this.write("' ?>\n");
            }
            this.select(this.BODY_SECTION);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void startTag(String tag) throws IOException {
        this.startTag(null, tag, null, true);
    }

    public void startTag(String tag, boolean finish) throws IOException {
        this.startTag(null, tag, null, finish);
    }

    public void startTag(String namespace, String tag) throws IOException {
        this.startTag(namespace, tag, null, true);
    }

    public void startTag(String namespace, String tag, boolean finish) throws IOException {
        this.startTag(namespace, tag, null, finish);
    }

    public void startTag(String namespace, String tag, String attributeString) throws IOException {
        this.startTag(namespace, tag, attributeString, true);
    }

    public void startTag(String namespace, String tag, String attributeString, boolean finish) throws IOException {
        String fullTag = namespace != null ? namespace + ":" + tag : tag;
        this.tags.push(fullTag);
        this.write("<");
        this.write(fullTag);
        if (attributeString != null) {
            if (!attributeString.startsWith(" ")) {
                this.write(" ");
            }
            this.write(attributeString);
        }
        if (finish) {
            this.finishStartTag();
        } else {
            this.setFirst(" ");
        }
        this.indentRight();
    }

    public void finishStartTag() throws IOException {
        this.write(">");
    }

    public void finishStartTag(boolean children, boolean useCr) throws IOException {
        if (!children) {
            this.write("/");
            this.indentLeft();
            this.tags.pop();
        }
        this.finishStartTag();
        if (useCr) {
            this.cr();
        }
    }

    public void endTag() throws IOException {
        this.endTag(true);
    }

    public void endTag(boolean useCr) throws IOException {
        this.indentLeft();
        String fullTag = (String)this.tags.pop();
        this.write("</");
        this.write(fullTag);
        this.write(">");
        if (useCr) {
            this.cr();
        }
    }
}

