/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev.gen;

import java.io.IOException;
import org.netbeans.modules.schema2beansdev.gen.GenBuffer;

public class IndentingWriter
extends GenBuffer {
    protected boolean[] crDone;
    protected int[] indentLevel;
    protected String indentString = "\t";

    public IndentingWriter(int bufferCount) {
        super(bufferCount);
        this.crDone = new boolean[bufferCount];
        this.indentLevel = new int[bufferCount];
        this.privateInit();
    }

    public IndentingWriter(IndentingWriter source) {
        super(source);
        this.indentString = source.indentString;
        this.crDone = new boolean[this.bufferCount];
        this.indentLevel = new int[this.bufferCount];
        for (int i = 0; i < this.bufferCount; ++i) {
            this.crDone[i] = source.crDone[i];
            this.indentLevel[i] = source.indentLevel[i];
        }
    }

    public void reset() {
        super.reset();
        this.privateInit();
    }

    private void privateInit() {
        for (int i = 0; i < this.bufferCount; ++i) {
            this.crDone[i] = true;
            this.indentLevel[i] = 0;
        }
    }

    public void writeTo(GenBuffer o) {
        super.writeTo(o);
        if (o instanceof IndentingWriter) {
            IndentingWriter out = (IndentingWriter)o;
            int minInCommonBufferCount = this.bufferCount;
            if (out.bufferCount < this.bufferCount) {
                minInCommonBufferCount = out.bufferCount;
            }
            for (int i = 0; i < minInCommonBufferCount; ++i) {
                out.crDone[i] = this.crDone[i];
                out.indentLevel[i] = this.indentLevel[i];
            }
        }
    }

    public void insertAdditionalBuffers(int offset, int count) {
        boolean[] newCrDone = new boolean[this.bufferCount + count];
        System.arraycopy(this.crDone, 0, newCrDone, 0, offset + 1);
        System.arraycopy(this.crDone, offset + 1, newCrDone, offset + 1 + count, this.bufferCount - offset - 1);
        for (int i = 0; i < count; ++i) {
            newCrDone[offset + 1 + i] = true;
        }
        this.crDone = newCrDone;
        int[] newIndentLevel = new int[this.bufferCount + count];
        System.arraycopy(this.indentLevel, 0, newIndentLevel, 0, offset + 1);
        System.arraycopy(this.indentLevel, offset + 1, newIndentLevel, offset + 1 + count, this.bufferCount - offset - 1);
        for (int i = 0; i < count; ++i) {
            newIndentLevel[offset + 1 + i] = 0;
        }
        this.indentLevel = newIndentLevel;
        super.insertAdditionalBuffers(offset, count);
    }

    public void setIndent(String indent) {
        this.indentString = indent;
    }

    public String getIndent() {
        return this.indentString;
    }

    public void cr() throws IOException {
        this.listOut[this.curOut].append("\n");
        this.crDone[this.curOut] = true;
    }

    public void write(String str) throws IOException {
        int len = str.length();
        if (len == 0) {
            return;
        }
        char lastChar = str.charAt(len - 1);
        if (lastChar == '\n') {
            int secondLastChar;
            char firstChar = str.charAt(0);
            int n = secondLastChar = len <= 1 ? 32 : (int)str.charAt(len - 2);
            if (firstChar == '}' || secondLastChar == 125) {
                this.indentLeft();
            }
            super.write(str.substring(0, len - 1));
            this.cr();
            if (secondLastChar == 123) {
                this.indentRight();
            }
        } else {
            super.write(str);
        }
    }

    public void writecr(String str) throws IOException {
        super.write(str);
        this.cr();
    }

    public void writecr(String s1, String s2) throws IOException {
        super.write(s1, s2);
        this.cr();
    }

    public void writecr(String s1, String s2, String s3) throws IOException {
        super.write(s1, s2, s3);
        this.cr();
    }

    public void writecr(String s1, String s2, String s3, String s4) throws IOException {
        super.write(s1, s2, s3, s4);
        this.cr();
    }

    public void indentRight() {
        int n = this.curOut;
        this.indentLevel[n] = this.indentLevel[n] + 1;
    }

    public void indentLeft() {
        int n = this.curOut;
        this.indentLevel[n] = this.indentLevel[n] - 1;
    }

    protected void beforeWriteHook() {
        if (this.crDone[this.curOut]) {
            this.indent();
            this.crDone[this.curOut] = false;
        }
    }

    public void indentOneLevel() {
        this.listOut[this.curOut].append(this.indentString);
    }

    public void indent() {
        for (int i = 0; i < this.indentLevel[this.curOut]; ++i) {
            this.indentOneLevel();
        }
    }
}

