/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class EntityParser {
    private Map entityMap;
    private File fileName;

    public EntityParser(File fileName) {
        this.fileName = fileName;
        this.entityMap = new HashMap();
    }

    public void parse() throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(this.fileName));
        String line = null;
        while ((line = br.readLine()) != null) {
            int startPos = line.indexOf("<!ENTITY ");
            if (startPos < 0) continue;
            this.addEntity(br, line.substring(startPos + 9));
        }
        br.close();
    }

    private void addEntity(BufferedReader br, String line) throws IOException {
        StringTokenizer tok = new StringTokenizer(line);
        if (!tok.hasMoreTokens()) {
            return;
        }
        String percentage = tok.nextToken();
        if (!"%".equals(percentage)) {
            return;
        }
        if (!tok.hasMoreTokens()) {
            return;
        }
        String key = tok.nextToken();
        int valueStartPos = line.indexOf(key) + key.length();
        String rest = line.substring(valueStartPos);
        if ((valueStartPos = rest.indexOf("\"")) < 0) {
            return;
        }
        String value = this.resolveValue(rest = rest.substring(valueStartPos + 1), br);
        if (value != null) {
            int refStart = value.indexOf("%");
            int refEnd = value.indexOf(";");
            if (refStart >= 0 && refEnd > refStart) {
                String entityKey = value.substring(refStart + 1, refEnd);
                String val = (String)this.entityMap.get(entityKey);
                if (val != null) {
                    String newValue = value.substring(0, refStart) + val + value.substring(refEnd + 1);
                    System.out.println("found ENTITY: % " + key + " \"" + newValue + "\"");
                    this.entityMap.put(key, newValue);
                }
            } else {
                System.out.println("found ENTITY: % " + key + " \"" + value + "\"");
                this.entityMap.put(key, value);
            }
        }
    }

    private String resolveValue(String lineRest, BufferedReader br) throws IOException {
        int index = lineRest.indexOf("\"");
        if (index >= 0) {
            return lineRest.substring(0, index);
        }
        StringBuffer buf = new StringBuffer(lineRest);
        buf.append("\n");
        int ch = br.read();
        while (ch != 34 && ch != 62 && ch != -1) {
            buf.append((char)ch);
            ch = br.read();
        }
        return buf.toString();
    }

    private boolean containsBlank(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (' ' != s.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public Reader getReader() throws IOException {
        StringBuffer buf = new StringBuffer();
        BufferedReader br = new BufferedReader(new FileReader(this.fileName));
        String line = null;
        while ((line = br.readLine()) != null) {
            int pos;
            if (line.indexOf("<!ENTITY ") >= 0) {
                line = this.removeEntityDeclaration(line, br);
            }
            if ((pos = line.indexOf("%")) >= 0) {
                StringTokenizer tok = new StringTokenizer(line.substring(pos), ";%");
                while (tok.hasMoreTokens()) {
                    String value;
                    String key = tok.nextToken();
                    if (key.length() <= 0 || this.containsBlank(key) || (value = (String)this.entityMap.get(key)) == null) continue;
                    line = line.replaceAll("%" + key + ";", value);
                }
            }
            if (line.length() <= 0) continue;
            buf.append(line);
        }
        br.close();
        return new StringReader(buf.toString());
    }

    private String removeEntityDeclaration(String line, BufferedReader br) throws IOException {
        int endPos;
        int start = line.indexOf("<!ENTITY ");
        StringBuffer buf = new StringBuffer();
        if (start > 0) {
            buf.append(line.substring(0, start));
        }
        if ((endPos = line.indexOf(">", start)) > 0) {
            buf.append(line.substring(endPos + 1));
            return buf.toString();
        }
        String ln = null;
        while (endPos < 0 && (ln = br.readLine()) != null) {
            endPos = ln.indexOf(">");
            if (endPos < 0) continue;
            buf.append(ln.substring(endPos + 1));
        }
        return buf.toString();
    }
}

