/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine;

public class ETLEngineExecEvent {
    private Throwable cause;
    private String errorMessage;
    private int execStatus;
    private String sourceName;
    private String targetTableName;
    private String executionId;

    public ETLEngineExecEvent(String sourceName, int execStatus, String errorMessage) {
        this.sourceName = sourceName;
        this.execStatus = execStatus;
        this.errorMessage = errorMessage;
    }

    public ETLEngineExecEvent(String sourceName, int execStatus, Throwable theCause) {
        this.sourceName = sourceName;
        this.execStatus = execStatus;
        this.errorMessage = theCause.getMessage();
        this.cause = theCause;
    }

    public ETLEngineExecEvent(int execStatus, String targetTableName, String executionId) {
        this.execStatus = execStatus;
        this.targetTableName = targetTableName;
        this.executionId = executionId;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public String getErrorMessage() {
        if (this.errorMessage == null) {
            return "";
        }
        return this.errorMessage;
    }

    public void getErrorMessage(String errorMsg) {
        this.errorMessage = errorMsg;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getStatus() {
        return this.execStatus;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public void setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
    }
}

