/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.tuple;

import java.util.Iterator;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.visual.AggregateItem;
import prefuse.visual.AggregateTable;
import prefuse.visual.VisualItem;
import prefuse.visual.tuple.TableVisualItem;

public class TableAggregateItem
extends TableVisualItem
implements AggregateItem {
    protected void init(Table table, Graph graph, int row) {
        this.m_table = table;
        this.m_row = this.m_table.isValidRow(row) ? row : -1;
    }

    public int getAggregateSize() {
        return ((AggregateTable)this.m_table).getAggregateSize(this.m_row);
    }

    public boolean containsItem(VisualItem item) {
        return ((AggregateTable)this.m_table).aggregateContains(this.m_row, item);
    }

    public void addItem(VisualItem item) {
        ((AggregateTable)this.m_table).addToAggregate(this.m_row, item);
    }

    public void removeItem(VisualItem item) {
        ((AggregateTable)this.m_table).removeFromAggregate(this.m_row, item);
    }

    public void removeAllItems() {
        ((AggregateTable)this.m_table).removeAllFromAggregate(this.m_row);
    }

    public Iterator items() {
        return ((AggregateTable)this.m_table).aggregatedTuples(this.m_row);
    }
}

