/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.FontMetrics;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.Hashtable;

public class StringLib {
    private static final String SUFFIX = "suffix";
    private static final String PREFIX = "prefix";
    private static Hashtable prefixSuffixT = new Hashtable();

    private StringLib() {
    }

    public static final String getArrayString(Object a) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('[');
        int size = Array.getLength(a);
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append(Array.get(a, i));
        }
        sbuf.append(']');
        return sbuf.toString();
    }

    public static String formatNumber(double number, int decimalPlaces) {
        String s = String.valueOf(number);
        int idx1 = s.indexOf(46);
        if (idx1 == -1) {
            return s;
        }
        int idx2 = s.indexOf(69);
        int dp = decimalPlaces + (idx2 >= 0 ? 0 : 1);
        String t = s.substring(0, Math.min(idx1 + dp, s.length()));
        if (idx2 >= 0) {
            t = t + s.substring(idx2);
        }
        return t;
    }

    public static String capitalizeFirstOnly(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        StringBuffer sbuf = new StringBuffer();
        char c = s.charAt(0);
        sbuf.append(Character.toUpperCase(c));
        boolean space = Character.isWhitespace(c);
        for (int i = 1; i < s.length(); ++i) {
            c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                space = true;
            } else if (space) {
                c = Character.toUpperCase(c);
                space = false;
            } else {
                c = Character.toLowerCase(c);
            }
            sbuf.append(c);
        }
        return sbuf.toString();
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static String abbreviate(String str, FontMetrics fm, int width) {
        int lastblank = 0;
        int nchars = 0;
        for (int cumx = 0; cumx < width && nchars < str.length(); cumx += fm.charWidth(str.charAt(nchars)), ++nchars) {
            if (!Character.isWhitespace(str.charAt(nchars))) continue;
            lastblank = nchars;
        }
        if (nchars < str.length() && lastblank > 0) {
            nchars = lastblank;
        }
        return nchars > 0 ? str.substring(0, nchars) : str;
    }

    public static String abbreviateName(String str, FontMetrics fm, int width) {
        if (fm.stringWidth(str) > width) {
            str = StringLib.abbreviateName(str, false);
        }
        if (fm.stringWidth(str) > width) {
            str = StringLib.abbreviateName(str, true);
        }
        return str;
    }

    private static String abbreviateName(String inString, boolean lastOnly) {
        StringReader in = new StringReader(inString);
        StreamTokenizer p = new StreamTokenizer(in);
        p.wordChars(38, 38);
        p.wordChars(64, 64);
        p.wordChars(58, 58);
        p.ordinaryChar(44);
        p.ordinaryChar(45);
        String lastNameHold = null;
        String lastInitialHold = null;
        StringBuffer outString = new StringBuffer();
        try {
            block9: while (true) {
                int c = p.nextToken();
                switch (c) {
                    case -1: {
                        break block9;
                    }
                    case 10: {
                        System.err.println("warning: unexpected EOL token");
                        continue block9;
                    }
                    case -2: {
                        continue block9;
                    }
                    case 44: {
                        break block9;
                    }
                    case -3: {
                        if (p.sval.endsWith(":")) {
                            outString.append(p.sval + " ");
                            continue block9;
                        }
                        if (prefixSuffixT.get(p.sval.toLowerCase()) != null) continue block9;
                        if (!lastOnly) {
                            if (lastInitialHold != null) {
                                outString.append(lastInitialHold);
                            }
                            lastInitialHold = p.sval.substring(0, 1) + ". ";
                        }
                        lastNameHold = p.sval;
                        continue block9;
                    }
                    default: {
                        continue block9;
                    }
                }
                break;
            }
            outString.append(lastNameHold);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outString.toString();
    }

    static {
        prefixSuffixT.put("mr", PREFIX);
        prefixSuffixT.put("mr.", PREFIX);
        prefixSuffixT.put("dr", PREFIX);
        prefixSuffixT.put("dr.", PREFIX);
        prefixSuffixT.put("lt", PREFIX);
        prefixSuffixT.put("lt.", PREFIX);
        prefixSuffixT.put("gen", PREFIX);
        prefixSuffixT.put("gen.", PREFIX);
        prefixSuffixT.put("sgt", PREFIX);
        prefixSuffixT.put("sgt.", PREFIX);
        prefixSuffixT.put("cmdr", PREFIX);
        prefixSuffixT.put("cmdr.", PREFIX);
        prefixSuffixT.put("cpt", PREFIX);
        prefixSuffixT.put("cpt.", PREFIX);
        prefixSuffixT.put("ii", SUFFIX);
        prefixSuffixT.put("iii", SUFFIX);
        prefixSuffixT.put("iv", SUFFIX);
        prefixSuffixT.put("jr", SUFFIX);
        prefixSuffixT.put("jr.", SUFFIX);
        prefixSuffixT.put("sr", SUFFIX);
        prefixSuffixT.put("sr.", SUFFIX);
    }
}

