/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Comparator;
import prefuse.data.Table;
import prefuse.data.column.Column;
import prefuse.data.event.ColumnListener;
import prefuse.data.event.TableListener;
import prefuse.data.util.Index;
import prefuse.data.util.RowManager;
import prefuse.util.collections.BooleanIntSortedMap;
import prefuse.util.collections.DoubleIntSortedMap;
import prefuse.util.collections.FloatIntSortedMap;
import prefuse.util.collections.IncompatibleComparatorException;
import prefuse.util.collections.IntIntSortedMap;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.IntSortedMap;
import prefuse.util.collections.LongIntSortedMap;
import prefuse.util.collections.ObjectIntSortedMap;
import prefuse.util.collections.SortedMapFactory;

public class TreeIndex
implements Index,
ColumnListener,
TableListener {
    protected Table m_table;
    protected RowManager m_rows;
    protected Column m_col;
    protected IntSortedMap m_index;
    protected boolean m_reindex;
    protected int m_colidx;

    public TreeIndex(Table t, RowManager rows, Column col, Comparator cmp) throws IncompatibleComparatorException {
        this.m_table = t;
        this.m_rows = rows;
        this.m_col = col;
        this.m_index = SortedMapFactory.getMap(col.getColumnType(), cmp, false);
        this.index();
        this.m_col.addColumnListener(this);
        this.m_table.addTableListener(this);
    }

    public void dispose() {
        this.m_col.removeColumnListener(this);
        this.m_table.removeTableListener(this);
    }

    public Comparator getComparator() {
        return this.m_index.comparator();
    }

    public int size() {
        return this.m_index.size();
    }

    private int getColumnIndex() {
        if (this.m_table.getColumn(this.m_colidx) != this.m_col) {
            this.m_colidx = this.m_table.getColumnNumber(this.m_col);
        }
        return this.m_colidx;
    }

    public void index() {
        int idx;
        this.m_index.clear();
        this.m_colidx = idx = this.getColumnIndex();
        IntIterator rows = this.m_rows.rows();
        if (this.m_index instanceof IntIntSortedMap) {
            IntIntSortedMap map = (IntIntSortedMap)this.m_index;
            while (rows.hasNext()) {
                int r = rows.nextInt();
                map.put(this.m_col.getInt(this.m_table.getColumnRow(r, idx)), r);
            }
        } else if (this.m_index instanceof LongIntSortedMap) {
            LongIntSortedMap map = (LongIntSortedMap)this.m_index;
            while (rows.hasNext()) {
                int r = rows.nextInt();
                map.put(this.m_col.getLong(this.m_table.getColumnRow(r, idx)), r);
            }
        } else if (this.m_index instanceof FloatIntSortedMap) {
            FloatIntSortedMap map = (FloatIntSortedMap)this.m_index;
            while (rows.hasNext()) {
                int r = rows.nextInt();
                map.put(this.m_col.getFloat(this.m_table.getColumnRow(r, idx)), r);
            }
        } else if (this.m_index instanceof DoubleIntSortedMap) {
            DoubleIntSortedMap map = (DoubleIntSortedMap)this.m_index;
            while (rows.hasNext()) {
                int r = rows.nextInt();
                map.put(this.m_col.getDouble(this.m_table.getColumnRow(r, idx)), r);
            }
        } else if (this.m_index instanceof BooleanIntSortedMap) {
            BooleanIntSortedMap map = (BooleanIntSortedMap)this.m_index;
            while (rows.hasNext()) {
                int r = rows.nextInt();
                map.put(this.m_col.getBoolean(this.m_table.getColumnRow(r, idx)), r);
            }
        } else if (this.m_index instanceof ObjectIntSortedMap) {
            ObjectIntSortedMap map = (ObjectIntSortedMap)this.m_index;
            while (rows.hasNext()) {
                int r = rows.nextInt();
                map.put(this.m_col.get(this.m_table.getColumnRow(r, idx)), r);
            }
        } else {
            throw new IllegalStateException();
        }
        this.m_reindex = false;
    }

    public void tableChanged(Table t, int start, int end, int col, int type) {
        if (type == 0 || t != this.m_table || col != -1) {
            return;
        }
        boolean insert = type == 1;
        for (int r = start; r <= end; ++r) {
            this.rowChanged(r, insert);
        }
    }

    private void rowChanged(int row, boolean insert) {
        int crow = this.m_rows.getColumnRow(row, this.getColumnIndex());
        if (this.m_index instanceof IntIntSortedMap) {
            IntIntSortedMap map = (IntIntSortedMap)this.m_index;
            int key = this.m_col.getInt(row);
            if (insert) {
                map.put(key, row);
            } else {
                map.remove(key, row);
            }
        } else if (this.m_index instanceof LongIntSortedMap) {
            LongIntSortedMap map = (LongIntSortedMap)this.m_index;
            long key = this.m_col.getLong(crow);
            if (insert) {
                map.put(key, row);
            } else {
                map.remove(key, row);
            }
        } else if (this.m_index instanceof FloatIntSortedMap) {
            FloatIntSortedMap map = (FloatIntSortedMap)this.m_index;
            float key = this.m_col.getFloat(crow);
            if (insert) {
                map.put(key, row);
            } else {
                map.remove(key, row);
            }
        } else if (this.m_index instanceof DoubleIntSortedMap) {
            DoubleIntSortedMap map = (DoubleIntSortedMap)this.m_index;
            double key = this.m_col.getDouble(crow);
            if (insert) {
                map.put(key, row);
            } else {
                map.remove(key, row);
            }
        } else if (this.m_index instanceof BooleanIntSortedMap) {
            BooleanIntSortedMap map = (BooleanIntSortedMap)this.m_index;
            boolean key = this.m_col.getBoolean(crow);
            if (insert) {
                map.put(key, row);
            } else {
                map.remove(key, row);
            }
        } else if (this.m_index instanceof ObjectIntSortedMap) {
            ObjectIntSortedMap map = (ObjectIntSortedMap)this.m_index;
            Object key = this.m_col.get(crow);
            if (insert) {
                map.put(key, row);
            } else {
                map.remove(key, row);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public void columnChanged(Column src, int type, int start, int end) {
        this.m_reindex = true;
    }

    public void columnChanged(Column src, int idx, boolean prev) {
        int row = this.m_rows.getTableRow(idx, this.getColumnIndex());
        if (row < 0) {
            return;
        }
        ((BooleanIntSortedMap)this.m_index).remove(prev, row);
        ((BooleanIntSortedMap)this.m_index).put(src.getBoolean(idx), row);
    }

    public void columnChanged(Column src, int idx, int prev) {
        int row = this.m_rows.getTableRow(idx, this.getColumnIndex());
        if (row < 0) {
            return;
        }
        ((IntIntSortedMap)this.m_index).remove(prev, row);
        ((IntIntSortedMap)this.m_index).put(src.getInt(idx), row);
    }

    public void columnChanged(Column src, int idx, long prev) {
        int row = this.m_rows.getTableRow(idx, this.getColumnIndex());
        if (row < 0) {
            return;
        }
        ((LongIntSortedMap)this.m_index).remove(prev, row);
        ((LongIntSortedMap)this.m_index).put(src.getLong(idx), row);
    }

    public void columnChanged(Column src, int idx, float prev) {
        int row = this.m_rows.getTableRow(idx, this.getColumnIndex());
        if (row < 0) {
            return;
        }
        ((FloatIntSortedMap)this.m_index).remove(prev, row);
        ((FloatIntSortedMap)this.m_index).put(src.getFloat(idx), row);
    }

    public void columnChanged(Column src, int idx, double prev) {
        int row = this.m_rows.getTableRow(idx, this.getColumnIndex());
        if (row < 0) {
            return;
        }
        ((DoubleIntSortedMap)this.m_index).remove(prev, row);
        ((DoubleIntSortedMap)this.m_index).put(src.getDouble(idx), row);
    }

    public void columnChanged(Column src, int idx, Object prev) {
        int row = this.m_rows.getTableRow(idx, this.getColumnIndex());
        if (row < 0) {
            return;
        }
        ((ObjectIntSortedMap)this.m_index).remove(prev, row);
        ((ObjectIntSortedMap)this.m_index).put(src.get(idx), row);
    }

    public int minimum() {
        return this.m_index.getMinimum();
    }

    public int maximum() {
        return this.m_index.getMaximum();
    }

    public int median() {
        return this.m_index.getMedian();
    }

    public int uniqueCount() {
        return this.m_index.getUniqueCount();
    }

    public IntIterator allRows(int type) {
        boolean ascending = (type & 0x20) > 0;
        return this.m_index.valueIterator(ascending);
    }

    public IntIterator rows(Object lo, Object hi, int type) {
        boolean hinc;
        if (!(this.m_index instanceof ObjectIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean reverse = (type & 0x10) > 0;
        boolean linc = (type & 8) > 0;
        boolean bl = hinc = (type & 2) > 0;
        if (lo == null) {
            lo = ObjectIntSortedMap.MIN_KEY;
        }
        if (hi == null) {
            hi = ObjectIntSortedMap.MAX_KEY;
        }
        ObjectIntSortedMap index = (ObjectIntSortedMap)this.m_index;
        if (reverse) {
            return index.valueRangeIterator(hi, hinc, lo, linc);
        }
        return index.valueRangeIterator(lo, linc, hi, hinc);
    }

    public IntIterator rows(int lo, int hi, int type) {
        if (!(this.m_index instanceof IntIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean reverse = (type & 0x10) > 0;
        boolean linc = (type & 8) > 0;
        boolean hinc = (type & 2) > 0;
        IntIntSortedMap index = (IntIntSortedMap)this.m_index;
        if (reverse) {
            return index.valueRangeIterator(hi, hinc, lo, linc);
        }
        return index.valueRangeIterator(lo, linc, hi, hinc);
    }

    public IntIterator rows(long lo, long hi, int type) {
        if (!(this.m_index instanceof LongIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean reverse = (type & 0x10) > 0;
        boolean linc = (type & 8) > 0;
        boolean hinc = (type & 2) > 0;
        LongIntSortedMap index = (LongIntSortedMap)this.m_index;
        if (reverse) {
            return index.valueRangeIterator(hi, hinc, lo, linc);
        }
        return index.valueRangeIterator(lo, linc, hi, hinc);
    }

    public IntIterator rows(float lo, float hi, int type) {
        if (!(this.m_index instanceof FloatIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean reverse = (type & 0x10) > 0;
        boolean linc = (type & 8) > 0;
        boolean hinc = (type & 2) > 0;
        FloatIntSortedMap index = (FloatIntSortedMap)this.m_index;
        if (reverse) {
            return index.valueRangeIterator(hi, hinc, lo, linc);
        }
        return index.valueRangeIterator(lo, linc, hi, hinc);
    }

    public IntIterator rows(double lo, double hi, int type) {
        if (!(this.m_index instanceof DoubleIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean reverse = (type & 0x10) > 0;
        boolean linc = (type & 8) > 0;
        boolean hinc = (type & 2) > 0;
        DoubleIntSortedMap index = (DoubleIntSortedMap)this.m_index;
        if (reverse) {
            return index.valueRangeIterator(hi, hinc, lo, linc);
        }
        return index.valueRangeIterator(lo, linc, hi, hinc);
    }

    public IntIterator rows(int val) {
        return this.rows(val, val, 42);
    }

    public IntIterator rows(long val) {
        return this.rows(val, val, 42);
    }

    public IntIterator rows(float val) {
        return this.rows(val, val, 42);
    }

    public IntIterator rows(double val) {
        return this.rows(val, val, 42);
    }

    public IntIterator rows(boolean val) {
        if (!(this.m_index instanceof BooleanIntSortedMap)) {
            throw new IllegalStateException();
        }
        BooleanIntSortedMap index = (BooleanIntSortedMap)this.m_index;
        return index.valueRangeIterator(val, true, val, true);
    }

    public IntIterator rows(Object val) {
        return this.rows(val, val, 42);
    }

    public int get(double x) {
        DoubleIntSortedMap index = (DoubleIntSortedMap)this.m_index;
        return index.get(x);
    }

    public int get(float x) {
        FloatIntSortedMap index = (FloatIntSortedMap)this.m_index;
        return index.get(x);
    }

    public int get(int x) {
        IntIntSortedMap index = (IntIntSortedMap)this.m_index;
        return index.get(x);
    }

    public int get(long x) {
        LongIntSortedMap index = (LongIntSortedMap)this.m_index;
        return index.get(x);
    }

    public int get(Object x) {
        ObjectIntSortedMap index = (ObjectIntSortedMap)this.m_index;
        return index.get(x);
    }
}

