/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class IntParser
implements DataParser {
    public Class getType() {
        return Integer.TYPE;
    }

    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(((Number)value).intValue());
    }

    public boolean canParse(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public Object parse(String text) throws DataParseException {
        return new Integer(this.parseInt(text));
    }

    public int parseInt(String text) throws DataParseException {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new DataParseException(e);
        }
    }
}

