/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import java.util.StringTokenizer;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class IntArrayParser
implements DataParser {
    public Class getType() {
        return int[].class;
    }

    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof int[])) {
            throw new IllegalArgumentException("This class can only format Objects of type int[].");
        }
        int[] values = (int[])value;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('[');
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append(values[i]);
        }
        sbuf.append(']');
        return sbuf.toString();
    }

    public boolean canParse(String text) {
        try {
            StringTokenizer st = new StringTokenizer(text, "\"[](){}, ");
            while (st.hasMoreTokens()) {
                Integer.parseInt(st.nextToken());
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public Object parse(String text) throws DataParseException {
        try {
            StringTokenizer st = new StringTokenizer(text, "\"[](){}, ");
            int[] array = new int[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                array[i] = Integer.parseInt(tok);
                ++i;
            }
            return array;
        }
        catch (NumberFormatException e) {
            throw new DataParseException(e);
        }
    }
}

