/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.jbi.wsdl;

import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.jbi.Messages;
import it.imolinfo.jbi4cics.jbi.wsdl.Jbi4CicsBinding;
import it.imolinfo.jbi4cics.jbi.wsdl.Jbi4CicsExtension;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Jbi4CicsBindingDeserializer
implements ExtensionDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4CicsBindingDeserializer.class);
    private static final Messages MESSAGES = Messages.getMessages(Jbi4CicsBindingDeserializer.class);

    Jbi4CicsBindingDeserializer() {
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element elem, Definition def, ExtensionRegistry extReg) throws WSDLException {
        Jbi4CicsBinding binding = (Jbi4CicsBinding)extReg.createExtension(parentType, elementType);
        String sameCopyCobol = DOMUtils.getAttribute((Element)elem, (String)"sameCopyCobol");
        binding.setServicePackageName(DOMUtils.getAttribute((Element)elem, (String)"servicePackageName"));
        binding.setCodePage(DOMUtils.getAttribute((Element)elem, (String)"codePage"));
        if (Jbi4CicsBindingDeserializer.isNullOrBlank(sameCopyCobol)) {
            binding.setSameCopyCobol(null);
        } else {
            binding.setSameCopyCobol(Boolean.valueOf(sameCopyCobol));
        }
        this.unmarshallCopiesCobol(binding, elem);
        return binding;
    }

    private static boolean isNullOrBlank(String str) {
        if (str != null) {
            for (int i = str.length() - 1; i >= 0; --i) {
                if (str.charAt(i) <= ' ') continue;
                return false;
            }
        }
        return true;
    }

    private void unmarshallCopiesCobol(Jbi4CicsBinding binding, Element elem) throws WSDLException {
        boolean copyCobolFound = false;
        boolean outCopyCobolFound = false;
        Element e = DOMUtils.getFirstChildElement((Element)elem);
        while (e != null) {
            if (QNameUtils.matches((QName)Jbi4CicsExtension.Q_ELEM_JBI4CICS_OUTPUT_COPY_COBOL, (Node)e)) {
                if (outCopyCobolFound) {
                    throw Jbi4CicsBindingDeserializer.createWSDLException("CIC001314_Element_found_many_times", Jbi4CicsExtension.Q_ELEM_JBI4CICS_OUTPUT_COPY_COBOL);
                }
                binding.setOutputCopyCobol(e.getTextContent());
                outCopyCobolFound = true;
            } else if (QNameUtils.matches((QName)Jbi4CicsExtension.Q_ELEM_JBI4CICS_COPY_COBOL, (Node)e)) {
                if (copyCobolFound) {
                    throw Jbi4CicsBindingDeserializer.createWSDLException("CIC001314_Element_found_many_times", Jbi4CicsExtension.Q_ELEM_JBI4CICS_COPY_COBOL);
                }
                binding.setCopyCobol(e.getTextContent());
                copyCobolFound = true;
            }
            e = DOMUtils.getNextSiblingElement((Element)e);
        }
        if (!copyCobolFound) {
            throw Jbi4CicsBindingDeserializer.createWSDLException("CIC001309_Copy_cobol_not_found", Jbi4CicsExtension.Q_ELEM_JBI4CICS_COPY_COBOL);
        }
        if (Boolean.FALSE.equals(binding.getSameCopyCobol()) && !outCopyCobolFound) {
            throw Jbi4CicsBindingDeserializer.createWSDLException("CIC001315_Output_copy_Cobol_required", null);
        }
    }

    private static WSDLException createWSDLException(String msgKey, Object msgArg) {
        String msg;
        if (msgArg == null) {
            LOG.error(msgKey);
            msg = MESSAGES.getString(msgKey, new Object[0]);
        } else {
            LOG.error(msgKey, msgArg);
            msg = MESSAGES.getString(msgKey, msgArg);
        }
        return new WSDLException(null, msg);
    }
}

