/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.jbi;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.jbi.Messages;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BCELClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(BCELClassLoader.class);
    private static final Messages MESSAGES = Messages.getMessages(BCELClassLoader.class);
    private Map<String, byte[]> classesCode = new HashMap<String, byte[]>();

    public BCELClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void addClass(String className, byte[] bytecode) {
        this.classesCode.put(className, bytecode);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytecode = this.classesCode.get(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("findClass(" + name + ")");
        }
        if (bytecode == null) {
            throw new ClassNotFoundException(MESSAGES.getString("CIC001042_Class_not_found", name));
        }
        return this.defineClass(name, bytecode, 0, bytecode.length);
    }
}

