/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.connection.jdbc.util;

import com.sun.rowset.CachedRowSetImpl;
import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.jbi.Messages;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class StatementInvocationHandler
implements InvocationHandler {
    private Connection connection;
    private Statement underlyingStatement;
    private boolean connected;
    private List<Command> commands = new ArrayList<Command>();
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;
    protected int resultSetHoldability = 2;
    private static final Logger LOG = LoggerFactory.getLogger(StatementInvocationHandler.class);
    private static final Messages MESSAGES = Messages.getMessages(StatementInvocationHandler.class);

    public StatementInvocationHandler() {
    }

    public StatementInvocationHandler(int resultSetType, int resultSetConcurrency) {
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public StatementInvocationHandler(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("get")) {
            if ("getUnderlyingStatement".equals(method)) {
                return this.getUnderlyingStatement();
            }
            if (method.equals("getConnection")) {
                return this.getConnection();
            }
            return this.handleGet(proxy, method, args);
        }
        if (method.getName().startsWith("set")) {
            if (method.getName().equals("setConnection")) {
                this.setConnection((Connection)args[0]);
                return null;
            }
            if (method.getName().equals("setConnected")) {
                this.setConnected((Boolean)args[0]);
                return null;
            }
            return this.handleSet(proxy, method, args);
        }
        if (method.getName().startsWith("execute")) {
            return this.handleExecute(proxy, method, args);
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        return this.handleOtherMethods(proxy, method, args);
    }

    public Object handleGet(Object proxy, Method method, Object[] args) throws SQLException {
        if (this.isConnected()) {
            return this.invokeMethod(method, args);
        }
        throw new SQLException("trying to invoke an execute method on a disconnected statement");
    }

    public Object handleSet(Object proxy, Method method, Object[] args) throws SQLException {
        if (this.isConnected()) {
            return this.invokeMethod(method, args);
        }
        this.commands.add(new Command(method, args));
        return null;
    }

    public Object handleExecute(Object proxy, Method method, Object[] args) throws SQLException {
        if (this.isConnected()) {
            return this.invokeMethod(method, args);
        }
        throw new SQLException(MESSAGES.getString("CIC000703_Error_invoking_execute_method", new Object[0]));
    }

    public Object handleOtherMethods(Object proxy, Method method, Object[] args) throws SQLException {
        if (this.isConnected()) {
            return this.invokeMethod(method, args);
        }
        this.commands.add(new Command(method, args));
        return null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection conn) {
        this.connection = conn;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) throws SQLException {
        if (connected) {
            if (this.connection != null) {
                if (this.underlyingStatement == null) {
                    this.underlyingStatement = this.createStatement();
                }
            } else {
                throw new SQLException(MESSAGES.getString("CIC000704_Error_setting_connected_state", new Object[0]));
            }
            for (Command command : this.commands) {
                Method method = command.getMethod();
                Object[] args = command.getArgs();
                this.invokeMethod(method, args);
            }
        } else {
            this.underlyingStatement = null;
            this.connection = null;
        }
        this.connected = connected;
    }

    protected Statement createStatement() throws SQLException {
        return this.connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
    }

    protected Object invokeMethod(Method method, Object[] args) throws SQLException {
        try {
            Object result = method.invoke((Object)this.underlyingStatement, args);
            if (result != null && result instanceof ResultSet) {
                CachedRowSetImpl cachedRowSet = new CachedRowSetImpl();
                cachedRowSet.populate((ResultSet)result);
                return cachedRowSet;
            }
            return result;
        }
        catch (IllegalAccessException e) {
            LOG.error("CIC000705_Illegal_access", new Object[]{method.toGenericString(), Arrays.toString(args), this.underlyingStatement}, e);
            throw new SQLException(MESSAGES.getString("CIC000705_Illegal_access", method.toGenericString(), Arrays.toString(args), this.underlyingStatement));
        }
        catch (InvocationTargetException e) {
            LOG.error("CIC000706_Target_exception", new Object[]{e.getTargetException()});
            Throwable targetException = e.getTargetException();
            if (targetException instanceof SQLException) {
                throw (SQLException)e.getTargetException();
            }
            throw new SQLException(MESSAGES.getString("CIC000706_Target_exception", targetException.getMessage()));
        }
    }

    public String toString() {
        return "connected: " + this.connected + ", " + (this.connected ? "connection: " + this.connection + ", " : "") + (this.connected ? "underlyingStatement: " + this.underlyingStatement + ", " : "") + (!this.connected ? "stacked commands: " + Arrays.toString(this.commands.toArray()) : "");
    }

    public Statement getUnderlyingStatement() {
        return this.underlyingStatement;
    }

    private static class Command {
        private Method method;
        private Object[] args;

        public Command(Method method, Object[] args) {
            this.method = method;
            this.args = args;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public void setArgs(Object[] args) {
            this.args = args;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public String toString() {
            return "method: " + this.method.toGenericString() + " ," + "args: " + Arrays.toString(this.args);
        }
    }
}

