/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.BasicAuthenticationRequiredException;
import com.meterware.servletunit.DispatchedRequestWrapper;
import com.meterware.servletunit.InvocationContext;
import com.meterware.servletunit.RequestDispatcherImpl;
import com.meterware.servletunit.ServletMetaData;
import com.meterware.servletunit.ServletRunner;
import com.meterware.servletunit.ServletUnitClient;
import com.meterware.servletunit.ServletUnitHttpRequest;
import com.meterware.servletunit.ServletUnitHttpResponse;
import com.meterware.servletunit.ServletUnitHttpSession;
import com.meterware.servletunit.ServletUnitWebResponse;
import com.meterware.servletunit.WebApplication;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Stack;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

class InvocationContextImpl
implements InvocationContext {
    private Stack _contextStack = new Stack();
    private URL _effectiveURL;
    private ServletUnitClient _client;
    private WebApplication _application;
    private FrameSelector _frame;
    private WebResponse _webResponse;

    public HttpServletRequest getRequest() {
        return this.getContext().getRequest();
    }

    public HttpServletResponse getResponse() {
        return this.getContext().getResponse();
    }

    public void service() throws ServletException, IOException {
        if (this.isFilterActive()) {
            this.getFilter().doFilter((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse(), this.getFilterChain());
        } else {
            this.getServlet().service((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        }
    }

    public Servlet getServlet() throws ServletException {
        return this.getContext().getServlet();
    }

    public WebResponse getServletResponse() throws IOException {
        if (this._contextStack.size() != 1) {
            throw new IllegalStateException("Have not returned from all request dispatchers");
        }
        if (this._webResponse == null) {
            HttpSession session = this.getRequest().getSession(false);
            if (session != null && session.isNew()) {
                Cookie cookie = new Cookie("JSESSION", session.getId());
                cookie.setPath(this._application.getContextPath());
                this.getResponse().addCookie(cookie);
            }
            this._webResponse = new ServletUnitWebResponse(this._client, this._frame, this._effectiveURL, this.getResponse(), this._client.getExceptionsThrownOnErrorStatus());
        }
        return this._webResponse;
    }

    public FrameSelector getFrame() {
        return this._frame;
    }

    public void pushIncludeRequest(RequestDispatcher rd, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.isFilterActive()) {
            throw new IllegalStateException("May not push an include request when no servlet is active");
        }
        this._contextStack.push(new ExecutionContext(DispatchedRequestWrapper.createIncludeRequestWrapper(request, rd), response, ((RequestDispatcherImpl)rd).getServletMetaData()));
    }

    public void pushForwardRequest(RequestDispatcher rd, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.isFilterActive()) {
            throw new IllegalStateException("May not push a forward request when no servlet is active");
        }
        this._contextStack.push(new ExecutionContext(DispatchedRequestWrapper.createForwardRequestWrapper(request, rd), response, ((RequestDispatcherImpl)rd).getServletMetaData()));
    }

    public void popRequest() {
        if (this.getContext().mayPopFilter()) {
            this.getContext().popFilter();
        } else {
            if (this._contextStack.size() == 1) {
                throw new IllegalStateException("May not pop the initial request");
            }
            this._contextStack.pop();
        }
    }

    public boolean isFilterActive() {
        return this.getContext().isFilterActive();
    }

    public Filter getFilter() throws ServletException {
        return this.getContext().getFilter();
    }

    public FilterChain getFilterChain() {
        return new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                InvocationContextImpl.this.pushFilter(servletRequest, servletResponse);
                InvocationContextImpl.this.service();
                InvocationContextImpl.this.popRequest();
            }
        };
    }

    public void pushFilter(ServletRequest request, ServletResponse response) {
        this.getContext().pushFilter(request, response);
    }

    InvocationContextImpl(ServletUnitClient client, ServletRunner runner, FrameSelector frame, WebRequest request, Dictionary clientHeaders, byte[] messageBody) throws IOException, MalformedURLException {
        this._client = client;
        this._application = runner.getApplication();
        this._frame = frame;
        URL requestURL = request.getURL();
        ServletUnitHttpRequest suhr = new ServletUnitHttpRequest(this._application.getServletRequest(requestURL), request, runner.getContext(), clientHeaders, messageBody);
        if (this._application.usesBasicAuthentication()) {
            suhr.readBasicAuthentication();
        } else if (this._application.usesFormAuthentication()) {
            suhr.readFormAuthentication();
        }
        HttpSession session = suhr.getSession(false);
        if (session != null) {
            ((ServletUnitHttpSession)session).access();
        }
        this._effectiveURL = this.computeEffectiveUrl(suhr, requestURL);
        this._contextStack.push(new ExecutionContext(suhr, new ServletUnitHttpResponse(), this._application.getServletRequest(this._effectiveURL)));
    }

    private URL computeEffectiveUrl(HttpServletRequest request, URL requestURL) {
        if (!this._application.requiresAuthorization(requestURL) || this.userIsAuthorized(request, requestURL)) {
            return requestURL;
        }
        if (request.getRemoteUser() != null) {
            throw new AccessDeniedException(requestURL);
        }
        if (this._application.usesBasicAuthentication()) {
            throw new BasicAuthenticationRequiredException(this._application.getAuthenticationRealm());
        }
        if (!this._application.usesFormAuthentication()) {
            throw new IllegalStateException("Authorization required but no authentication method defined");
        }
        ((ServletUnitHttpSession)request.getSession()).setOriginalURL(requestURL);
        return this._application.getLoginURL();
    }

    private boolean userIsAuthorized(HttpServletRequest request, URL requestURL) {
        String[] roles = this._application.getPermittedRoles(requestURL);
        for (int i = 0; i < roles.length; ++i) {
            if (!request.isUserInRole(roles[i])) continue;
            return true;
        }
        return false;
    }

    private ExecutionContext getContext() {
        return (ExecutionContext)this._contextStack.lastElement();
    }

    static class FilterContext {
        HttpServletRequest _request;
        HttpServletResponse _response;

        public FilterContext(HttpServletRequest request, HttpServletResponse response) {
            this._request = request;
            this._response = response;
        }

        public HttpServletResponse getResponse() {
            return this._response;
        }

        public HttpServletRequest getRequest() {
            return this._request;
        }
    }

    static class ExecutionContext {
        private HttpServletResponse _response;
        private HttpServletRequest _request;
        private ServletMetaData _metaData;
        private Stack _filterStack = new Stack();

        ExecutionContext(HttpServletRequest request, HttpServletResponse response, ServletMetaData metaData) {
            this._request = request;
            this._response = response;
            this._metaData = metaData;
        }

        boolean isFilterActive() {
            return this.getFilterIndex() < this._metaData.getFilters().length;
        }

        Servlet getServlet() throws ServletException {
            if (this.isFilterActive()) {
                throw new IllegalStateException("Current context is a filter - may not request servlet.");
            }
            return this._metaData.getServlet();
        }

        HttpServletResponse getResponse() {
            return this._filterStack.isEmpty() ? this._response : ((FilterContext)this._filterStack.lastElement()).getResponse();
        }

        HttpServletRequest getRequest() {
            return this._filterStack.isEmpty() ? this._request : ((FilterContext)this._filterStack.lastElement()).getRequest();
        }

        public Filter getFilter() throws ServletException {
            if (!this.isFilterActive()) {
                throw new IllegalStateException("Current context is a servlet - may not request filter.");
            }
            return this._metaData.getFilters()[this.getFilterIndex()].getFilter();
        }

        public void pushFilter(ServletRequest request, ServletResponse response) {
            if (!this.isFilterActive()) {
                throw new IllegalStateException("Current context is a servlet - may not push filter.");
            }
            if (!(request instanceof HttpServletRequest)) {
                throw new IllegalArgumentException("HttpUnit does not support non-HTTP request wrappers");
            }
            if (!(response instanceof HttpServletResponse)) {
                throw new IllegalArgumentException("HttpUnit does not support non-HTTP response wrappers");
            }
            this._filterStack.push(new FilterContext((HttpServletRequest)request, (HttpServletResponse)response));
        }

        public boolean mayPopFilter() {
            return this.getFilterIndex() > 0;
        }

        public void popFilter() {
            this._filterStack.pop();
        }

        private int getFilterIndex() {
            return this._filterStack.size();
        }
    }

    class AccessDeniedException
    extends HttpException {
        public AccessDeniedException(URL baseURL) {
            super(403, "Access Denied", baseURL);
        }
    }
}

