/*
	GXAnim : A GTK frontend to XAnim
	by Robert Warren
	(c) 1999

	This program is covered under the General Public License.
	See COPYING file for licensing information.
	
	===============================================

	valxanim.c

	validate a movie file and supply movie information data

*/


/* 
	function : val_xanim_file

	authenticate a given movie file and supply it's native parameters.  
*/

#include "header.h"

void *val_xanim_file (xcontrol *control) 
{
	FILE *fp;

	char *basic = "+Zv +v +f";
	char *command = _NULL;
	char *line = _NULL;
	char *word = _NULL;

	void *start = _NULL;
	I8 count = 0;

	command = dalloc(command, strlen(control->defaults->xanimprog) + strlen(basic) + 
		strlen(control->movie->name) + 9);

	sprintf(command, "%s %s \"%s\" ", control->defaults->xanimprog, basic, control->movie->name);
	
if (control->defaults->verbose) {
	fprintf(stderr, "\nname : %s\n", control->movie->name);
	fprintf(stderr, "%s\n", command);
}

	control->stats->type = _NULL;
	fp = popen(command, "r");

	if (fp) {

		do {
			line = fgets(dalloc(line, 80), 80, fp); 
			
			/* XAnim version number */
	
			if (line && (word = extr_string(line, " Rev ", " by "))) {
				control->stats->version = dalloc(control->stats->version, 10);
				sprintf(control->stats->version, "%s", word);

if (control->defaults->verbose) {
				fprintf(stderr, "version = %s\n", control->stats->version);
}

			}

			/* movie clip type */

			if (line && (word = extr_string(line, "Reading ", " File "))) {
				control->stats->type = dalloc(control->stats->type, 15);
				sprintf(control->stats->type, "%s", word);

if (control->defaults->verbose) {					
				fprintf(stderr, "type = %s\n", control->stats->type);
}

			}

			
			/* frames and sizing info */

			if (line && (word = extr_string(line, " Size=", _NULL))) {

				sscanf(word, "%ix%i", &control->stats->size_x, &control->stats->size_y);

				word = extr_string(line, "Frames=", _NULL);
				sscanf(word, "%i", &control->stats->frames);

if (control->defaults->verbose) {
				fprintf(stderr, "size : x= %i, y= %i\n", control->stats->size_x, control->stats->size_y);
				fprintf(stderr, "framecount = %i frames\n", control->stats->frames);
}
				
			} else
				if (line && (word = extr_string(line, "MPG ", "frames"))) {
					sscanf(word, "%ix%i", &control->stats->size_x, &control->stats->size_y);

if (control->defaults->verbose) {
					fprintf(stderr, "size : x= %i, y= %i\n", control->stats->size_x, control->stats->size_y);
}

				}

		} while (line);

		dfree(word);
		pclose(fp);

	} 

	dfree(command);
	return (control->stats->type);
}




