/* GSnes9x -- callbacks.h
 * Copyright (C) 1999 Canek Pelez Valds <canek@abulafia.fciencias.unam.mx>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GSNES9X_CALLBACKS_H
#define GSNES9X_CALLBACKS_H

void play_cb               (GtkWidget *widget, GSnes9xData *gsnes_data);
void add_cb                (GtkWidget *widget, GSnes9xData *gsnes_data);
void remove_cb             (GtkWidget *widget, GSnes9xData *gsnes_data);
gint quit_by_close_cb      (GtkWidget *app);
void quit_by_menu_cb       (GtkWidget *widget, GSnes9xData *gsnes_data);
void readme_cb             (GtkWidget *widget, gint part);
void about_cb              (GtkWidget *widget, GSnes9xData *gsnes_data);

void add_ok_cb             (GtkWidget *widget, AddROMInfo *addrom_info);
void add_cancel_cb         (GtkWidget *widget, AddROMInfo *addrom_info);
void add_free_cb           (GtkWidget *widget, AddROMInfo *addrom_info);
void remove_ok_cb          (GtkWidget *widget, GSnes9xData *gsnes_data);
void about_destroyed_cb    (GtkWidget *widget, GSnes9xData *gsnes_data);
void help_destroyed_cb     (GtkWidget *widget, GSnes9xData *gsnes_data);

void selection_ok_cb       (GtkWidget *widget, BrowseStruct *bs);
void press_key_cb          (GtkWidget *widget, GdkEvent *event, GSnes9xData* gsnes_data);

void select_rom_cb         (GtkWidget *clist, gint row, gint col,
			    GdkEventButton *event, GSnes9xData* gsnes_data);
gint right_select_rom_cb   (GtkWidget *clist, GdkEventButton *event,
			    GSnes9xData* gsnes_data);
gint right_click_pixmap_cb (GtkWidget *clist, GdkEventButton *event,
			    GSnes9xData* gsnes_data);

void destroy_data_cb       (GtkWidget *widget, GtkWidget *data);
void toggle_to_active_cb   (GtkWidget *widget, GtkWidget *data);

void no_dialog_cb          (GtkWidget *widget, GSnes9xData *gsnes_data);

void resize_pixmap_cb      (GtkWidget *widget, GdkRectangle *area, GSnes9xData *gsnes_data);
void popup_menu_detacher   (GtkWidget *attach_widget, GtkMenu *menu);

#endif

/* callbacks.h ends here. */
