/*
 * HistoryManager.java
 *
 * Created on December 13, 2000, 8:49 AM
 */

package com.sun.enterprise.config.backup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileInputStream;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.status.Status;
import com.sun.enterprise.config.backup.pluggable.EnvironmentFactory;
import com.sun.enterprise.config.backup.pluggable.BackupEnvironment;
import com.sun.enterprise.config.backup.utils.LoggerHelper;
import com.sun.enterprise.config.backup.utils.FactoryHelper;

/**
 * History Manager manages the history for the backup-restore
 * functionality. It keeps track of the backupHistory and
 * saves it in a file.
 * @author  sridatta
 */
public class HistoryManager 
    implements StatusConstants, EnvironmentConstants {
    
    private String _backupHistoryFile;
    
    /** Creates a new instance of HistoryManager */
    public HistoryManager() throws BackupException {
       _backupHistoryFile = initBackupHistoryFile();
    }
    
     public void addHistoryEntry(Status status) {
         addHistoryEntry(new HistoryEntry(status));
     }
    
    public void addHistoryEntry(HistoryEntry historyEntry) {
        //open file and add the entry
        if (historyEntry == null) return;
        
        FileOutputStream fos = null;
        try {
            File f = new File(_backupHistoryFile);
            if(!f.exists()) {
                f.createNewFile();
            }
            fos = new FileOutputStream(f, true);
            
            //add a newline between history entries
            if(f.exists() && f.length() != 0)
                fos.write(DefaultConstants.NEWLINE_CHARACTER.getBytes());
            
            fos.write(historyEntry.toString().getBytes());
        } catch(Exception e) {
            //log and ignore
            LoggerHelper.warning("append_to_backup_history_failed", e);
        } finally {
             try {
                fos.close();
            } catch(Exception ex){}
        }
    }
    
    public BackupHistory getBackupHistory(int num) {
        ArrayList arr = new ArrayList();
        BackupHistory res;
        
        BufferedReader in = null;
        try {
            File f = new File(_backupHistoryFile);
           if(!f.exists()) {
                return new BackupHistory(_backupHistoryFile);
            }
            
            in = new BufferedReader(new FileReader(f));

            String line;
          while((line=in.readLine()) != null) {
              HistoryEntry he = new HistoryEntry(line);
              arr.add(he);
          }
         
        } catch(Exception e) {
            //log and ignore
            LoggerHelper.warning("loading_backup_history_failed", e);
        } finally {
            try {
                in.close();
            } catch(Exception ex){}
        }
        
        res = new BackupHistory(ArrayListToHistoryEntryArr(arr, num), _backupHistoryFile);
        //FIXME Return last n
        return res;
    }
    
    private HistoryEntry[] ArrayListToHistoryEntryArr(ArrayList arr, int num) {
        if(arr==null || arr.size() == 0) return null;
        int size = arr.size();
        
        if(size > num) size = num;
        
        HistoryEntry[] res = new HistoryEntry[size];
        int j=0;
        for(int i=(arr.size()-size);i<arr.size();i++,j++) {
            res[j] = (HistoryEntry) arr.get(i);
        }
        return res;
    }
    
    private String initBackupHistoryFile() throws BackupException {
        BackupEnvironment be = FactoryHelper.getEnv();
        String name =  be.getBackupHistoryFileName();
        String dir = be.getDirectoryToStoreHistoryFile();
        
        return dir + File.separator + name;
    }
        
    public String getBackupHistoryFile() {
        return _backupHistoryFile;
    }
    
    public void clearHistory() {
        try {
            File f = new File(_backupHistoryFile);
            f.delete();
            f.createNewFile();
        } catch(Exception io) {
            LoggerHelper.warning("error_clearing_history", io);
        }
    }
}