/*
 * BackupStatus.java
 *
 * Created on December 13, 2000, 6:52 AM
 */

package com.sun.enterprise.config.backup;

import java.io.Serializable;
import java.util.ArrayList;

/**
 *
 * @author  sridatta
 */
public class BackupHistory implements Serializable, EnvironmentConstants {
    
   private final HistoryEntry[] _historyEntries;
   private final String _historyFileName;
    /** Creates a new instance of BackupHistory */
    public BackupHistory(String fileName) {
        _historyEntries = null;
        _historyFileName = fileName;
    }
    
    public BackupHistory(HistoryEntry[] historyEntries, String fileName) {
        _historyEntries = historyEntries;
        _historyFileName = fileName;

    }
    
    public HistoryEntry[] getHistoryEntries() {
        return _historyEntries;
    }
    
    public int size() {
        if(_historyEntries == null) return 0;
        return _historyEntries.length;
    }
    
    public String getBackupHistoryFile() {
        return _historyFileName;
    }
    
    public String toString() {
        String res = "";
        if(_historyEntries == null) return res;
        
        for(int i = 0; i < _historyEntries.length; i++ ) {
            if(res != "") {
                res+=DefaultConstants.NEWLINE_CHARACTER;
            }
            res += _historyEntries[i];
        }
        return res;
    }
}