/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.enterprise.admin.wsmgmt;

import javax.xml.ws.handler.MessageContext;
import javax.xml.soap.SOAPMessage;
import java.util.Iterator;
import java.util.Set;
import java.util.Map;

/**
 * SOAP Message Context. This encapsulates the required data for web services
 * management either from JAXWS 1.0 or 2.0 MessageContext.
 */
public class SOAPMessageContext_2_0 implements SOAPMessageContext {

    /**
     * Constructed from JAXWS 2.0 MessageContext
     *
     * @param   msg    the detail message for this exception
     */
    public SOAPMessageContext_2_0(
        com.sun.enterprise.webservice.SOAPMessageContext smc) {
        if (smc == null) {
            throw new IllegalArgumentException();
        }
        _smc = smc;
    }

    /**
     * Gets the SOAPMessage for this web service invocation.
     *
     * @return  SOAPMessage for this web service invocation
     */
    public SOAPMessage getMessage() {
        return _smc.getMessage();
    }

    /**
     * Gets the PropertyNames for this web service invocation.
     *
     * @return  PropertyNames for this web service invocation
     */
    public Iterator getPropertyNames() {
        Set keySet = _smc.keySet();
        if ( keySet != null) {
            return keySet.iterator();
        } else {
            return null;
        }
    }

    /**
     * Gets the PropertyNames for this web service invocation.
     *
     * @return  PropertyNames for this web service invocation
     */
    public Object getProperty(String name) {
        // convert jax-rpc property to jax ws property
        if (( name != null) && (
        "com.sun.xml.rpc.server.http.HttpServletRequest".equals(name))) {
            name = MessageContext.SERVLET_REQUEST;
        }
        return _smc.get(name);
    }

    /**
     * Sets the SOAPMessage in the message context.
     *
     * @param msg the SOAPMessage to be set in the message context
     */
    public void setMessage(SOAPMessage msg) {
            _smc.setMessage(msg);
    }
    /**
     * Gets the HTTP Request headers in the message.
     *
     * @return the HTTP Request headers in the message.
     */
    public String getHTTPRequestHeaders() {
        Map headerMap = (Map)_smc.get(MessageContext.HTTP_REQUEST_HEADERS);
        return Utils.getString(headerMap);
    }

    /**
     * Gets the HTTP Response headers in the message.
     *
     * @return the HTTP Response headers in the message.
     */
    public String getHTTPResponseHeaders() {
        Map headerMap = (Map)_smc.get(MessageContext.HTTP_RESPONSE_HEADERS);
        return Utils.getString(headerMap);
    }

    // Private variables
    private com.sun.enterprise.webservice.SOAPMessageContext _smc = null;
}
