/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.naming;

import java.util.Hashtable;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.StateFactory;

/**
 * Interface representing Namespace/NamingSystem.
 * Associated with each namespace is a name parser,
 * object factories and state factories.
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 * @version $Revision: 1.3 $
 */
public interface Namespace
    extends ObjectFactory, StateFactory
{
    NameParser getNameParser()
        throws NamingException;
}
