/* Copyright (C) 1990, 1992, 1993, 1994 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* zdps1.c */
/* Display PostScript graphics extensions */
#include "ghost.h"
#include "errors.h"
#include "oper.h"
#include "gsmatrix.h"
#include "gscoord.h"
#include "gspath.h"
#include "gspath2.h"
#include "gsstate.h"
#include "ialloc.h"
#include "igstate.h"
#include "ivmspace.h"
#include "store.h"
#include "stream.h"
#include "ibnum.h"

/* the X people can't make their headers define what they need automatically... */
#define NEED_REPLIES
#define NEED_EVENTS
#include "x_.h"                 /* standard X include files */
#include "X11/Xproto.h"
#include "X11/Xlibint.h"        /* we need internals, too */
#include "dpsNXprops.h" /* has the property definitions */
#include "DPS/XDPSproto.h"
#include "DPSCAPproto.h"
#include "DPSCAP.h"
#include "DPS/dpsNXargs.h"

#include "gx.h"
#include "gxdevice.h"
#include "gdevx.h"
extern gx_device_X gs_x11_device;

#include "gsdpsx.h"

/* ------ Agent state ------ */

/* - .startXdpsagent <bool> */
private int
zstartXdpsagent(register os_ptr op)
{	push(1);
	make_bool(op, gs_startXdpsagent(igs, imemory));
	return 0;
}

/* - currentXgcdrawable <int> <int> <int> <int> */
/* - currentXgcdrawable gc drawable x y */
private int
zcurrentXgcdrawable(register os_ptr op)
{       gx_device_X *xdev;
        xdev = (gx_device_X*)gs_currentdevice(igs);
        if (xdev->dname != gs_x11_type_name)
              return e_typecheck;
        push(4);
        make_int(op-3, (int)XGContextFromGC(xdev_gc_inline(xdev)));
        make_int(op-2, (int)xdev_win_inline(xdev));
        make_int(op-1, (int)0);
        make_int(op  , (int)0);
        return 0;
}

/* <int> <int> <int> <int> setXgcdrawable - */
/* gc drawable x y setXgcdrawable - */
private int
zsetXgcdrawable(register os_ptr op)
{       gx_device_X *xdev;
        gs_matrix *initial_matrix;
        xdev = (gx_device_X*)gs_currentdevice(igs);
        if (xdev->dname != gs_x11_type_name)
              return e_typecheck;

        check_type(op[-3], t_integer);
        check_type(op[-2], t_integer);
        check_type(op[-1], t_integer);
        check_type(op[ 0], t_integer);
        if (op[-3].value.intval)
            xdev_gc_inline(xdev)->gid = (GContext)(op[-3].value.intval);
        if (op[-2].value.intval)
            gdev_x_set_drawable(xdev, (Drawable)(op[-2].value.intval));

#ifdef DEBUG
	dprintf4("setXgcdrawable gc: %08X, drawable: %08x, x: %d, y: %d\n",
                 (int)op[-3].value.intval, (int)op[-2].value.intval,
                 (int)op[-1].value.intval, (int)op[ 0].value.intval);
#endif

        initial_matrix = xdev_initial_matrix_inline(xdev);
        initial_matrix->tx = op[-1].value.intval;
        initial_matrix->ty = op[ 0].value.intval;
        gs_initmatrix(igs);
        gs_initclip(igs);
        pop(4);

        return 0;
}


/* - currentXoffset <int> <int> */
/* - currentXoffset x y */
private int
zcurrentXoffset(register os_ptr op)
{       gx_device_X *xdev;
        gs_matrix *initial_matrix;
        xdev = (gx_device_X*)gs_currentdevice(igs);
        if (xdev->dname != gs_x11_type_name)
              return e_typecheck;
        push(2);
        initial_matrix = xdev_initial_matrix_inline(xdev);
        make_int(op-1, (int)initial_matrix->tx);
        make_int(op  , (int)initial_matrix->ty);
        return 0;
}

/* <int> <int> setXoffset - */
/* x y setXoffset - */
private int
zsetXoffset(register os_ptr op)
{       gx_device_X *xdev;
        gs_matrix *initial_matrix;
        xdev = (gx_device_X*)gs_currentdevice(igs);
        if (xdev->dname != gs_x11_type_name)
              return e_typecheck;
        check_type(op[-1], t_integer);
        check_type(op[ 0], t_integer);
#ifdef DEBUG
        dprintf2("setXoffset, x: %d, y: %d\n", (int)op[-1].value.intval, (int)op[0].value.intval);
#endif
        initial_matrix = xdev_initial_matrix_inline(xdev);
        initial_matrix->tx = op[-1].value.intval;
        initial_matrix->ty = op[ 0].value.intval;
        /* reset the drawable to force window recalculation */
        gdev_x_set_drawable(xdev, (Drawable)(xdev_win_inline(xdev)));
        gs_initmatrix(igs);
        gs_initclip(igs);
        pop(2);

        return 0;
}
                   
/* ------ Initialization procedure ------ */

BEGIN_OP_DEFS(zdpsx_op_defs) {
		op_def_begin_level2(),
		/* agent state */
        {"1.startXdpsagent", zstartXdpsagent},
        {"0currentXgcdrawable", zcurrentXgcdrawable},
        {"4setXgcdrawable", zsetXgcdrawable},
        {"0currentXoffset", zcurrentXoffset},
        {"2setXoffset", zsetXoffset},
END_OP_DEFS(0) }

