/* Copyright (C) 1996 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* gxdcolor.c */
/* Pure and null device color implementation */
#include "gx.h"
#include "gxdcolor.h"
#include "gxdevice.h"

/* Define the standard device color types. */
private dev_color_proc_load(gx_dc_no_load);
private dev_color_proc_fill_rectangle(gx_dc_no_fill_rectangle);
private dev_color_proc_load(gx_dc_pure_load);
private dev_color_proc_fill_rectangle(gx_dc_pure_fill_rectangle);
const gx_device_color_procs
  gx_dc_procs_none =
    { gx_dc_no_load, gx_dc_no_fill_rectangle, 0, 0 },
  gx_dc_procs_pure =
    { gx_dc_pure_load, gx_dc_pure_fill_rectangle, 0, 0 };
#undef gx_dc_type_none
const gx_device_color_procs _ds *gx_dc_type_none = &gx_dc_procs_none;
#define gx_dc_type_none (&gx_dc_procs_none)
#undef gx_dc_type_pure
const gx_device_color_procs _ds *gx_dc_type_pure = &gx_dc_procs_pure;
#define gx_dc_type_pure (&gx_dc_procs_pure)

/* Define a null RasterOp source. */
const gx_rop_source_t gx_rop_no_source = { gx_rop_no_source_body };

/* Null color */
private int
gx_dc_no_load(gx_device_color *pdevc, const gs_state *ignore_pgs)
{	return 0;
}
private int
gx_dc_no_fill_rectangle(const gx_device_color *pdevc, int x, int y,
  int w, int h, gx_device *dev, gs_logical_operation_t lop,
  const gx_rop_source_t *source)
{	return 0;
}

/* Pure color */
private int
gx_dc_pure_load(gx_device_color *pdevc, const gs_state *ignore_pgs)
{	return 0;
}
/* Fill a rectangle with a pure color. */
/* Note that we treat this as "texture" for RasterOp. */
private int
gx_dc_pure_fill_rectangle(const gx_device_color *pdevc, int x, int y,
  int w, int h, gx_device *dev, gs_logical_operation_t lop,
  const gx_rop_source_t *source)
{	if ( source == NULL && lop_no_S_is_T(lop) )
	  return (*dev_proc(dev, fill_rectangle))(dev, x, y, w, h,
						  pdevc->colors.pure);
	{ gx_color_index colors[2];

	  colors[0] = colors[1] = pdevc->colors.pure;
	  if ( source == NULL )
	    source = &gx_rop_no_source;
	  return (*dev_proc(dev, strip_copy_rop))(dev, source->sdata,
					    source->sourcex, source->sraster,
					    source->id,
					    (source->use_scolors ?
					     source->scolors : NULL),
					    NULL /*arbitrary*/, colors,
					    x, y, w, h, 0, 0, lop);
	}
}
