/* This file is Copyright 1993 by Clifford A. Adams */
/* svdata.c
 *
 * mostly manipulation of the structures sv_ents and sv_groups
 */

#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "artio.h"
#include "final.h"	/* assert() */
#include "trn.h"
#include "cache.h"
#include "bits.h"
#include "decode.h"
#include "hash.h"
#include "head.h"
#include "intrp.h"
#include "kfile.h"
#include "rcln.h"
#include "rcstuff.h"
#include "ngdata.h"	/* access_ng() */
#include "rthread.h"	/* ov_opened */
#include "ng.h"
#include "score.h"	/* sc_delay */
#include "scan.h"
#include "smisc.h"
#include "scanart.h"	/* sa_mode_read_elig */
#include "scmd.h"
#include "sdisp.h"
#include "sorder.h"

#include "svirt.h"
#include "svmisc.h"
#include "svfile.h"
#include "term.h"
#include "util.h"
#ifdef SCORE
#include "score.h"
#endif
#include "INTERN.h"
#include "svdata.h"

extern HASHTABLE *msgid_hash;

/* initialize current context with default values */
void
sv_init_context()
{
    sv_contexts = (SV_CONTEXT*)NULL;
    sv_max_contexts = sv_num_contexts = 0;
}

void
sv_save_context()
{
    int i;

    /* save the old context */
    i = sv_num_contexts-1;
    if (i>=0) {			/* there was an old one */
	s_save_context();
	sv_contexts[i].num_ents = sv_num_ents;
	sv_contexts[i].ents_alloc = sv_ents_alloc;
	sv_contexts[i].ents = sv_ents;
	sv_contexts[i].num_groups = sv_num_groups;
	sv_contexts[i].groups_alloc = sv_groups_alloc;
	sv_contexts[i].groups = sv_groups;
	/* save flags */
	sv_contexts[i].follow = sv_follow;
	sv_contexts[i].e_unread = sv_e_unread;
	sv_contexts[i].e_minused = sv_e_minused;
	sv_contexts[i].e_minscore = sv_e_minscore;
	sv_contexts[i].e_maxused = sv_e_maxused;
	sv_contexts[i].e_maxscore = sv_e_maxscore;
	sv_contexts[i].score_order = sv_score_order;
	sv_contexts[i].show_author = sv_show_author;
	sv_contexts[i].show_subjects_only = sv_show_subjects_only;
	sv_contexts[i].show_groups = sv_show_groups;
    }
}
/* saves the current context then creates and initializes a new context */
void
sv_new_context()
{
    int cnum;
    int i;

    sv_save_context();

    sv_num_contexts++;
    i = sv_num_contexts-1;
    if (i==0) {		/* first context */
	sv_max_contexts = sv_num_contexts;
	sv_contexts = (SV_CONTEXT*)safemalloc(sizeof(SV_CONTEXT));
    }
    if (sv_num_contexts>sv_max_contexts) {
	sv_contexts = (SV_CONTEXT*)saferealloc((char*)sv_contexts,
			(i+1)*sizeof(SV_CONTEXT));
	sv_max_contexts++;
    }
    cnum = s_new_context(S_VIRT);
    s_change_context(cnum);
    sv_contexts[i].cnum = cnum;
    sv_init_ents();
    sv_init_groups();

    sv_contexts[i].title = (char*)NULL;
    sv_contexts[i].filename = (char*)NULL;
    /* set flags to defaults (?) later */
    sv_set_screen();
    sv_save_context();
}

/* removes the current virtual scan context.
 * If this was the last context, frees the context variables.
 */
void
sv_cleanup()
{
    int i;

    /* free the entries (and sub-structures) */
    sv_free_ents();
    sv_free_groups();

    /* delete the scan-context */
    i = sv_num_contexts-1;
    if (i<0)
	return;
    free(sv_contexts[i].title);
    sv_contexts[i].title = (char*)NULL;
    /* deal with temporary files */
    if (sv_contexts[i].filename) {
	if (strnEQ(sv_contexts[i].filename,"/tmp/strn",9)) {
	    UNLINK(sv_contexts[i].filename);
	}
	free(sv_contexts[i].filename);
    }
    s_delete_context(sv_contexts[i].cnum);
    sv_num_contexts--;
    if (sv_num_contexts>0)
	return;
    /* free all of it if the last context was deleted */
    sv_initialized = 0;
    free(sv_contexts);
    sv_contexts = (SV_CONTEXT*)NULL;
    sv_max_contexts = sv_num_contexts = 0;
}

/* restores a saved context */
void
sv_restore_context()
{
    int i;

    i = sv_num_contexts-1;
    /* bring back the old context */
    s_change_context(sv_contexts[i].cnum);
    sv_num_ents = sv_contexts[i].num_ents;
    sv_ents_alloc = sv_contexts[i].ents_alloc;
    sv_ents = sv_contexts[i].ents;
    sv_num_groups = sv_contexts[i].num_groups;
    sv_groups_alloc = sv_contexts[i].groups_alloc;
    sv_groups = sv_contexts[i].groups;

    sv_follow = sv_contexts[i].follow;
    sv_e_unread = sv_contexts[i].e_unread;
    sv_e_minused = sv_contexts[i].e_minused;
    sv_e_minscore = sv_contexts[i].e_minscore;
    sv_e_maxused = sv_contexts[i].e_maxused;
    sv_e_maxscore = sv_contexts[i].e_maxscore;
    sv_score_order = sv_contexts[i].score_order;
    sv_show_author = sv_contexts[i].show_author;
    sv_show_subjects_only = sv_contexts[i].show_subjects_only;
    sv_show_groups = sv_contexts[i].show_groups;
}

/* returns index into sv_groups */
/* pass more information later? */
int
sv_add_group(name)
char *name;		/* name of the newsgroup to add */
{
    int cur;		/* current group for working */
    int i;

    for (i=0;i<sv_num_groups;i++) {
	if (strEQ(name,sv_groups[i].name))
	    return(i);
    }
/* later--check to see if it is really in .newsrc */
    sv_num_groups++;
    if (sv_num_groups > sv_groups_alloc) {
	sv_groups_alloc += 100;
	if (sv_groups_alloc==100) {	/* newly allocated */
	    sv_groups = (SV_GROUPDATA*)safemalloc(sv_groups_alloc*
					sizeof(SV_GROUPDATA));
        } else {
	    sv_groups = (SV_GROUPDATA*)saferealloc((char*)sv_groups,
			sv_groups_alloc*sizeof(SV_GROUPDATA));
	}
    }
    cur = sv_num_groups-1;
    sv_groups[cur].name = savestr(name);
    return(cur);
}

/* returns true if group already added. */
/* right now this also happens if articles were added, but soon it should
 * check a bitflag
 */
bool
sv_group_added(name)
char *name;
{
    int i;
    for (i=0;i<sv_num_groups;i++)
	if (strEQ(name,sv_groups[i].name))
	    return(TRUE);
    return(FALSE);
}

void
sv_init_groups()
{
    sv_num_groups = sv_groups_alloc = 0;
    sv_groups = (SV_GROUPDATA*)NULL;
    return;
}

void
sv_free_groups()
{
    int i;

    if (sv_num_groups) {
	for (i=0;i<sv_num_groups;i++)
	    if (sv_groups[i].name)
		free(sv_groups[i].name);
	free(sv_groups);
    }
    sv_num_groups = sv_groups_alloc = 0;
}

bool
sv_init_ents()
{
    sv_num_ents = sv_ents_alloc = 0;
    sv_ents = (SV_ENTRYDATA*)NULL;
    return(TRUE);
}

/* only passes type since other data is type-specific */
/* returns index into sv_ents */
int
sv_add_ent(type)
int type;
{
    int cur;			/* current entry number */

    sv_num_ents++;
    if (sv_num_ents > sv_ents_alloc) {
	sv_ents_alloc += 100;
	if (sv_ents_alloc==100) {	/* newly allocated */
	    /* don't use number 0--just allocate it and skip it */
	    sv_num_ents = 2;
	    sv_ents = (SV_ENTRYDATA*)safemalloc(sv_ents_alloc*
					sizeof(SV_ENTRYDATA));
        } else {
	    sv_ents = (SV_ENTRYDATA*)saferealloc((char*)sv_ents,
			sv_ents_alloc*sizeof(SV_ENTRYDATA));
	}
    }
    cur = sv_num_ents-1;
    s_order_add(cur);
    sv_ents[cur].type = type;
    sv_ents[cur].desc = Nullch;
    sv_ents[cur].flags = 0;
    sv_ents[cur].msgid = Nullch;
    sv_ents[cur].group = 0;
    sv_ents[cur].artnum = 0;
    sv_ents[cur].author = Nullch;
    sv_ents[cur].subject = Nullch;
    sv_ents[cur].score = 0;
    return(cur);
}

void
sv_sub_ent(ent)
int ent;		/* entry to be subtracted */
{
    sv_ents[ent].type = -1;	/* ineligible entry */
}

/* consider a separate function to free a single entry? */
/* frees the entry structures for the current context */
void
sv_free_ents()
{
    int i;

    /* entry 0 is uninitialized and unused */
    for (i=1;i<sv_num_ents;i++) {
	if (sv_ents[i].desc)
	    free(sv_ents[i].desc);
	if (sv_ents[i].subject)
	    free(sv_ents[i].subject);
	if (sv_ents[i].author)
	    free(sv_ents[i].author);
	if (sv_ents[i].msgid)
	    free(sv_ents[i].msgid);
    }
    if (sv_ents)
	free(sv_ents);
    sv_num_ents = sv_ents_alloc = 0;
}

/* returns the entry number if the message-id has been added previously */
/* returns 0 if entry was not found */
int
sv_id_added(id)
char *id;
{
    int i;

    for (i=1;i<sv_num_ents;i++)
	if (strEQ(sv_ents[i].msgid,id))
	    return(i);
    return(0);
}

/* callers must save context */
int
sv_go_art(grp,artnum)
int grp;		/* index into sv_group */
ART_NUM artnum;		/* not used just yet. */
{
    char *name;
    int i;
    name = sv_groups[grp].name;

    printf("going to group %s, art #%d\n",name,(int)artnum) FLUSH;
    set_ngname(name);
    ng = find_ng(ngname);
    if (ng == nextrcline) {		/* not in .newsrc == not avail. */
	printf("\nsv_go_art(%s): attempted to go to group not in .newsrc.\n",
		name) FLUSH;
	return(-1);
    }
/* change this later to use silent toread? */
    set_toread(ng);		/* just in case something changed */
    if (toread[ng] == TR_UNSUB) {	/* unsubscribed? */
	/* not allowed now, but might be later */
	printf("\n group %s unsubscribed, ignoring article.\n",name)
	  FLUSH;
	return(-1);
    }
    sv_article = artnum;
#ifdef SCORE
    /* don't score unless necessary */
    sc_delay  = TRUE;
#endif
    s_follow_temp = FALSE;
    sv_reading = TRUE;
    i = do_newsgroup(Nullch);
    sv_reading = FALSE;
    s_follow_temp = FALSE;
#ifdef SCORE
    sc_delay = FALSE;
#endif
    return(i);
}


void
sv_close_group(dobits)
bool_int dobits;			/* if TRUE, do bits_to_rc */
{
    if (!sv_cur_group)			/* nothing to do then */
	return;
    free(sv_cur_group);
    sv_cur_group = Nullch;
    sv_cur_gnum = -1;
#ifdef SCORE
    if (sc_initialized)
	sc_cleanup();
#endif

    if (artfp != Nullfp) {		/* article still open? */
	fclose(artfp);			/* close it */
	artfp = Nullfp;			/* and tell the world */
	openart = 0;
    }
    if (dobits)
	bits_to_rc();			/* reconstitute .newsrc line */
}

/* does more than sv_close_group because the user was probably
 * interacting with the group.
 */
void
sv_close_current()
{
    decode_end();
#ifdef KILLFILES
	kill_unwanted(firstart,"\nCleaning up...\n\n",FALSE);
					/* do cleanup from KILL file, if any */
#endif
    if (sa_initialized)
	sa_cleanup();
#ifdef SCORE
    if (sc_initialized)
	sc_cleanup();
#endif
    in_ng = FALSE;			/* leave newsgroup state */
    if (artfp != Nullfp) {		/* article still open? */
	fclose(artfp);			/* close it */
	artfp = Nullfp;			/* and tell the world */
	openart = 0;
    }
    deselect_all();
    yankback();				/* do a Y command */
    bits_to_rc();			/* reconstitute .newsrc line */
    close_cache();			/* be safe on cache behavior */
    doing_ng = FALSE;			/* tell sig_catcher to cool it */
    write_rc();				/* and update .newsrc */
    rc_changed = FALSE;			/* tell sig_catcher it is ok */
    if (chdir(spool)) {
	printf(nocd,spool) FLUSH;
	sig_catcher(0);
    }
#ifdef KILLFILES
    if (localkfp) {
	fclose(localkfp);
	localkfp = Nullfp;
    }
#endif
}

/* returns TRUE if successful */
/* perhaps later have a silence flag */
bool
sv_open_group(gname,unread_only)
char *gname;
bool_int unread_only;		/* if true, skip fully-read groups */
{
    bool old_always;		/* old value of thread_always */

    if (sv_cur_group && strEQ(sv_cur_group,gname))
	return(TRUE);		/* group is already open */
    if (sv_cur_group)
	sv_close_group(TRUE);	/* close old before opening new */

    /* include already-read stuff if filter allows */
    if (!sv_f_unread)
	unread_only = FALSE;

    sv_cur_group = savestr(gname);
    sv_cur_gnum = sv_add_group(gname);
    set_ngname(gname);
    ng = find_ng(ngname);
    if (ng == nextrcline) {		/* not in .newsrc == not avail. */
	printf("\n(group %s not in .newsrc)\n", gname) FLUSH;
	sv_close_group(FALSE);
	return(FALSE);
    }
    set_toread(ng);		/* just in case something changed */
    if (toread[ng] == TR_BOGUS) {
	sv_close_group(FALSE);
	return(FALSE);
    }
    if (toread[ng] == TR_UNSUB) {	/* unsubscribed? */
	/* reading unsub'ed is not allowed now, but might be later */
	printf("\n(group %s is unsubscribed).\n", gname) FLUSH;
	sv_close_group(FALSE);
	return(FALSE);
    }

    if (unread_only && (toread[ng] == TR_NONE) && sv_f_unread) {
	printf("\n(nothing unread in %s)\n", gname) FLUSH;
	sv_close_group(FALSE);
	return(FALSE);		/* nothing to read here */
    }

    /* initialize the newsgroup data structures */

    printf("\n(Opening group %s)\n",gname) FLUSH;
    if (!unread_only) {
	old_always = thread_always;
	thread_always = TRUE;
    }
    if (!access_ng()) {
	sv_close_group(FALSE);
	if (!unread_only)
	    thread_always = old_always;
	return(FALSE);
    }
#if 0
    (void)cache_all_arts();
#endif

    if (!unread_only)
	thread_always = old_always;

#ifdef SCORE
    sc_init(TRUE);		/* score all before continuing */
#endif
    return(TRUE);
}

static long scorespin = 0;

/* returns TRUE if added */
bool
sv_add_article(a,desc)
ART_NUM a;
char *desc;	/* optional description */
{
    long i;
    long score;
    char *id;

    if ((!sv_cur_group) || (sv_cur_gnum<0))
	return(FALSE);
    if (is_unavailable(a))
	return(FALSE);
    if (sv_f_unread && was_read(a))
	return(FALSE);
#ifdef SCORE
    if (!(SCORED(a)) && (!((scorespin++)%20))) {
	putchar('.');
	fflush(stdout);
    }
    score = sc_score_art(a,TRUE);
    if (sv_f_minused && (score<sv_f_minscore))
	return(FALSE);
    if (sv_f_maxused && (score>sv_f_maxscore))
	return(FALSE);
#else
    score = 0;
#endif
    /* has this article been added before? */
    id = fetchlines(a,MESSID_LINE);	/* fetchlines saves string */
    if (sv_id_added(id)) {
	free(id);
	return(FALSE);
    }
    i = sv_add_ent(1);
    sv_ents[i].group = sv_cur_gnum;
    sv_ents[i].artnum = a;
    sv_ents[i].msgid = id;
    sv_ents[i].score = score;
    if (sv_line_desc)
	sv_ents[i].desc = savestr(sv_line_desc);
    /* fetchlines will do the savestr for us */
    sv_ents[i].subject = fetchlines(a,SUBJ_LINE);
    if ((!sv_ents[i].subject) || (!*(sv_ents[i].subject))) {
	if (sv_ents[i].subject)
	    free(sv_ents[i].subject);
	sv_ents[i].subject = savestr("<<no subject>>");
    }
    sv_ents[i].author = fetchlines(a,FROM_LINE);
    if ((!sv_ents[i].author) || (!*(sv_ents[i].author))) {
	bool old_untrim;
	old_untrim = untrim_cache;
	untrim_cache = TRUE;
	if (sv_ents[i].author)
	    free(sv_ents[i].author);
	sv_ents[i].author = fetchlines(a,FROM_LINE);
	untrim_cache = old_untrim;
    }
    return(TRUE);
}

/* "subtracts" a message-id */
void
sv_sub_id(msgid)
char *msgid;
{
    int e;

    e = sv_id_added(msgid);
    if (!e) {	/* was not added previously */
	/* add it to the db as deleted (so it will not appear later) */
	e = sv_add_ent(-1);	/* deleted type */
	sv_ents[e].msgid = savestr(msgid);
    }
    sv_sub_ent(e);
}

/* add/subtract the group to/from the virtual group list */
void
sv_use_group(name,flag)
char *name;
bool_int flag;		/* TRUE = add, FALSE = subtract */
{
    ART_NUM a;
    int i;
    int total;			/* added for this group */

    if (!flag) {
	/* effectively remove group by adding it empty, and removing
	 * any articles that were in the group.
	 */
	int gnum;
	gnum = sv_add_group(name);
	for (i=0;i<sv_num_ents;i++)
	    if (sv_ents[i].group == gnum)
		sv_sub_ent(i);
	return;
    }

    /* subtract groups that are ineligible by score */
#ifdef SCORE
    if ((sv_f_minused && sv_f_maxused) && (sv_f_minscore>sv_f_maxscore)) {
	sv_add_group(name);	/* so that it will be ineligible later */
	return;
    }
#endif

    if (sv_group_added(name) && !sv_refreshing)
	return;		/* don't add twice */

    if (!sv_open_group(name,TRUE))
	return;

    total = 0;
    if (sv_f_unread)
	a = firstart;	/* unread articles */
    else
	a = absfirst;	/* all articles */
    for (; a <= lastart ; a++) {
	if (int_count)
	    break;
	if (sv_add_article(a,Nullch))
	    total++;
    }
    if (a==lastart+1)
	a = lastart;
    sv_groups[sv_cur_gnum].lastart = a;
    sv_close_group(TRUE);
    printf("(%d article%sadded)\n",total,(total==1)?" ":"s ");
}

void
sv_go_group(gname)
char *gname;
{
    (void)sv_open_group(gname,TRUE);
}

/* copied from rt-process.c */
void
sv_fix_msgid(msgid)
char *msgid;
{
    register char *cp;

    if ((cp = index(msgid, '@')) != Nullch) {
	while (*++cp) {
	    if (isupper(*cp)) {
		*cp = tolower(*cp);	/* lower-case domain portion */
	    }
	}
    }
}

#if 0
/* useful for debugging */
static void sv_walk_msgid(data, extra)
HASHDATUM *data;
int extra;
{
    register ARTICLE *ap = (data->dat_ptr? (ARTICLE*)data->dat_ptr
					: article_ptr(data->dat_len));
    register int flags;
    char ch;

    if (ap->msgid)
	printf("%s\n",ap->msgid);
}
#endif

ART_NUM
sv_msgid_to_num(msgid)
char *msgid;
{
    static char msgid_buf[LBUFLEN];
    register ARTICLE *article;
    HASHDATUM data;
#if 0
    ART_NUM a;
    char *s;
#endif

    /* check to see if the current newsgroup is valid */
    if ((!sv_cur_group) || (sv_cur_gnum<0))
	return(0);

    strcpy(msgid_buf,msgid);
    sv_fix_msgid(msgid_buf);
    data = hashfetch(msgid_hash, msgid_buf, strlen(msgid_buf));
    if (!(article = (ARTICLE *)data.dat_ptr)) {
	if (data.dat_len)
	    return((ART_NUM)data.dat_len);
    }
#if 0
/* this shouldn't be necessary now, but it could be useful (?) */
    /* The article wasn't in the hashed data, but don't give up just yet. */
    /* Search for the ID in the headers. */
    for (a=lastart;a>=absfirst;a--) {
	if ((article_ptr(a)->flags & AF_MISSING) ||
	    (sv_f_unread && was_read(a)))
	    continue;
	s = fetchcache(a,MESSID_LINE,TRUE);
	if (!s || !*s)
	    continue;
	if (strEQ(msgid,s)) {
	    return(a);
	}
    }
#endif
    return(0);
}

void
sv_junk_ent(ent)
long ent;
{
    if (sv_ents[ent].type == 1)
	addartnum(sv_ents[ent].artnum,sv_groups[sv_ents[ent].group].name);
    /* consider complaining later? */
}

void
sv_unjunk_ent(ent)
long ent;
{
    if (sv_ents[ent].type == 1)
	subartnum(sv_ents[ent].artnum,sv_groups[sv_ents[ent].group].name);
    /* consider complaining later? */
}

/* returns first eligbile marked article or 0 */
long
sv_first_marked_elig()
{
    long e;
    e = s_first();
    if (!e)
	return(0);
    if (!s_eligible(e))
	e = s_next_elig(e);
    while (e) {
	if (sv_marked(e))
	    return(e);
	e = s_next_elig(e);
    }
    return(0);
}
#endif /* SCAN */
