/* This file is Copyright 1993 by Clifford A. Adams */
/* svcmd.c
 *
 * virtual scan command interpreter
 */

#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "final.h"		/* assert() */
#include "init.h"
#include "cache.h"
#include "bits.h"
#include "ngdata.h"		/* abs1st[] */
#include "rcln.h"		/* ngmax[] */
#include "rcstuff.h"		/* toread[] */
#include "ng.h"			/* setdflt() */
#include "scan.h"
#include "scmd.h"
#include "sdisp.h"
#include "smisc.h"	/* needed? */
#include "sorder.h"
#include "spage.h"
#include "samain.h"	/* sa_mark_stay */
#include "svirt.h"
#include "svdata.h"
#include "svmisc.h"
#include "svfile.h"
#include "term.h"
#include "trn.h"		/* ng */
#include "INTERN.h"
#include "svcmd.h"

/* for debugging */
bool sv_testing = FALSE;

void
sv_go_bot()
{
    s_ref_all = TRUE;
    s_goxy(0,LINES-s_bot_lines);	/* go to bottom bar */
    erase_eol();			/* erase to end of line */
    s_goxy(0,LINES-s_bot_lines);	/* go (back?) to bottom bar */
    fflush(stdout);			/* do it *now* */
}

/* interprets command in TRN-global buf */
int
sv_docmd()
{
    long e;		/* entry pointed to */
    long b;		/* misc. artnum */
    int i;		/* for misc. purposes */

    e = page_ents[s_ptr_page_line].entnum;
    switch(*buf) {
	case 'Q':	/* make this do something different later? */
	case 'q':	/* quit from context or strn */
	    sv_go_bot();
	    return(SV_QUIT);
	case '\n':
	case ' ':	/* read article (marked or current) */
sv_read_marked:
	    /* search for a marked article */
	    s_refill = TRUE;
	    b = sv_first_marked_elig();
	    if (b) {		/* a marked elig. entry found */
		e = b;		/* read this instead */
		sv_clearmark(e);
	    }
	    /* FALL THROUGH */
	case 'r':	/* read pointed-to entry now */
	    s_refill = TRUE;
	    sv_go_bot();
	    switch (sv_ents[e].type) {
		case 1:		/* normal article */
		    sv_save_context();
		    xmouse_off();
		    i = sv_go_art(sv_ents[e].group,sv_ents[e].artnum);
		    xmouse_on();
		    /* return to the virtual scan-context */
		    sv_restore_context();
		    sv_loop = TRUE;		/* just in case */
		    s_ref_all = TRUE;
		    s_refill = TRUE;
		    if (i==NG_SELNEXT) {
			b = sv_first_marked_elig();
			if (b)
			    goto sv_read_marked;
		    }
		    return(0);
		default:
		    printf("Entry pointed to has an illegal type!\n") FLUSH;
		    assert(FALSE);
		    /* NOTREACHED */
	    }
	    break;
	case Ctl('e'):	/* edit current virtual group file */
	    xmouse_off();
	    sv_edit_file();
	    xmouse_on();
	    s_ref_all = TRUE;
	    break;
#ifdef SCORE
	case 'o':
	    s_refill = s_ref_all = TRUE;
	    sv_score_order = !sv_score_order;
	    s_sort();
	    (void)s_go_top_ents();
	    break;
#endif
	case 'a':	/* toggle author display */
	    s_ref_desc = 0;
	    sv_show_author = !sv_show_author;
	    break;
	case 'G':	/* toggle group display */
	    s_ref_all = TRUE;
	    sv_show_groups = !sv_show_groups;
	    break;
	case 'S':	/* toggle subjonly flag */
	    s_ref_all = TRUE;
	    sv_show_subjects_only = !sv_show_subjects_only;
	    break;
	case 'U':	/* toggle unread/unread+read */
	    s_refill = TRUE;
	    s_ref_top = TRUE;
	    sv_e_unread = !sv_e_unread;
	    (void)s_go_top_ents();
	    break;
	case 'f':	/* follow */
	    sv_follow = !sv_follow;
	    s_ref_top = TRUE;
	    break;
	case 'm':	/* mark/unmark single article */
	    s_rub_ptr();
	    if (sv_marked(e))
		sv_clearmark(e);
	    else
		sv_mark(e);
	    s_ref_status_onpage(e);
/* later use some sv_ flag variable, but for now be nice. */
	    if (!sa_mark_stay) {
		/* go to next art on page or top of page if at bottom */
		if (s_ptr_page_line<(s_bot_ent)) { /* more on page */
		    s_ptr_page_line +=1;
		}
		else
		    s_go_top_page();	/* wrap around to top */
	    }
	    break;
	case 'k':
	case ',':
	    /* later do a subject-thread-follow */
	    /* FALL THROUGH */
	case 'j':	/* junk current article */
	    sv_junk_ent(e);
	    s_refill = TRUE;
	    if (!sv_e_unread)	/* show read too */
		s_ref_all = TRUE;
	    break;
	case 'y':	/* "yank" (mark as unread) this article */
	    sv_unjunk_ent(e);
	    s_refill = TRUE;
	    if (!sv_e_unread)	/* show read too */
		s_ref_all = TRUE;
	    break;
	case 'Y':	/* "yank" all marked articles */
	    s_refill = TRUE;
	    b = s_first();
	    if (!b)
		return(0);
	    if (!s_eligible(b))
		b = s_next_elig(b);
	    for (;b;b=s_next_elig(b))
		if (sv_marked(b)) {
		    sv_unjunk_ent(b);
		    sv_clearmark(b);
		}
	    if (!sv_e_unread)	/* show read too */
		s_ref_all = TRUE;
	    break;
	case 'D':	/* junk all unmarked articles on page, and start
			 * reading if an article is marked.
			 */
	    s_refill = TRUE;
	    for (i=0;i<=s_bot_ent;i++)
		if (!sv_marked(page_ents[i].entnum))
		    sv_junk_ent(page_ents[i].entnum);
	    if (sv_first_marked_elig())
		goto sv_read_marked;
	    if (!sv_e_unread)	/* show read too */
		s_ref_all = TRUE;
	    break;
	case 'X':	/* junk all unmarked articles, and start reading
			 * if an article is marked.
			 */
	    *buf = '?';				/* for finish_cmd() */
	    if (!s_finish_cmd("Junk all unmarked articles"))
		break;
	    if ((buf[1] != 'Y') && (buf[1] != 'y'))
		break;
	    s_refill = TRUE;
	    b = s_first();
	    if (!b)
		return(0);
	    if (!s_eligible(b))
		b = s_next_elig(b);
	    for (;b;b=s_next_elig(b))
		if (!sv_marked(b))
		    sv_junk_ent(b);
	    if (sv_first_marked_elig())
		goto sv_read_marked;
	    if (!sv_e_unread)	/* show read too */
		s_ref_all = TRUE;
	    break;
	case 'J':	/* junk all *marked* articles */
	    *buf = '?';				/* for finish_cmd() */
	    if (!s_finish_cmd("Junk all marked articles"))
		break;
	    if ((buf[1] != 'Y') && (buf[1] != 'y'))
		break;
	    s_refill = TRUE;
	    b = s_first();
	    if (!b)
		return(0);
	    if (!s_eligible(b))
		b = s_next_elig(b);
	    for (;b;b=s_next_elig(b))
		if (sv_marked(b)) {
		    sv_junk_ent(b);
		    sv_clearmark(b);
		}
	    if (!sv_e_unread)	/* show read too */
		s_ref_all = TRUE;
	    break;
#ifdef UNDEF
	case 'R':
	    sv_go_bot();
	    printf("Refreshing virtual newsgroup\n") FLUSH;
	    s_ref_all = TRUE;
	    s_refill = TRUE;
	    sv_refresh();
	    break;
#endif
	case Ctl('t'):	/* testing vector */
	    sv_testing = TRUE;
	    return(0);
	default:
	    s_beep();
	    break;
    }
    return(0);
}
#endif /* SCAN */
