/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 *  GUS PnP related functions
 */

#include "driver.h"

#ifdef GUSCFG_PNP

/*
 *
 */

#define PNP_ID_GRAVIS		0x1e560001

#define PNP_DEV_AUDIO		0
#define PNP_DEV_EXT		1
#define PNP_DEV_GAME		2
#define PNP_DEV_EMULATION	3
#define PNP_DEV_MPU401		4

#if 0
#define MPU401_TEST
#endif

/*
 *
 */

#if 0

static void gus_pnp_power( unsigned char mode )
{
  unsigned long flags;
  
  CLI( &flags );
  OUTB( 0xf2, _PIDXR );		/* select _PPWRI */
  OUTB( mode, _PNPWRP );	/* write mode */
  STI( &flags );
}

#endif

static void gus_pnp_key( void )
{
  unsigned char code = 0x6a, msb;
  int i;
  
  OUTB( 0x00, _PIDXR );
  OUTB( 0x00, _PIDXR );
  
  OUTB( code, _PIDXR );
  
  for ( i = 1; i < 32; i++ )
    {
      msb = ((code & 0x01)^((code & 0x02)>>1)) << 7;
      code = (code >> 1) | msb;
      OUTB( code, _PIDXR );
    }  
}

static void gus_pnp_wait( void )
{
  OUTB( 0x02, _PIDXR );
  OUTB( 0x02, _PNPWRP );	/* place all pnp cards in wait-for-key state */
}

static void gus_pnp_wake( unsigned char csn )
{
  unsigned long flags;

  CLI( &flags );
  OUTB( 0x03, _PIDXR );		/* select PWAKEI */
  OUTB( csn, _PNPWRP );		/* write csn */
  STI( &flags );
}

static void gus_pnp_device( unsigned char dev )
{
  unsigned long flags;
  
  CLI( &flags );
  OUTB( 0x07, _PIDXR );		/* select PLDNI */
  OUTB( dev, _PNPWRP );		/* write dev */
  STI( &flags );
}

static void gus_pnp_activate( unsigned char dev, unsigned char value )
{
  unsigned long flags;

  gus_pnp_device( dev );
  CLI( &flags );
  OUTB( 0x30, _PIDXR );		/* select ACTIVATE_DEV */
  OUTB( value, _PNPWRP );	/* write mode */
  STI( &flags );
  gus_delay1( 1 );
}

static void gus_pnp_peek( int rdp, int bytes, unsigned char *data )
{
  int i, d;
  
  for ( i = 1; i <= bytes; i++ )
    {
      OUTB( 0x05, _PIDXR );	/* select PRESSI */
      while ( 1 )
        {
          d = INB( rdp );
          if ( d == 0 ) continue;
          break;
        }
      if ( !( d & 1 ) )
        {
          *data++ = 0xff;
          continue;
        }
      OUTB( 0x04, _PIDXR );	/* select PRESDI */
      d = INB( rdp );		/* read resource byte */
      if ( data != NULL ) *data++ = d;
    }
}

static int gus_pnp_ping( int *rrdp, int idx, unsigned int vendorID )
{
  int rdp, csn;
  unsigned int test;
  unsigned char vendor[ 9 ];

#if 0
  for ( rdp = 0x200; rdp < 0x23f; rdp += 0x04 )
    {
      printk( "p = 0x%x, v = 0x%x -- ", rdp, inl( rdp ) );
    }
  return 0;
#endif
  gus_pnp_key();
  gus_pnp_wake( 1 );
  gus_pnp_peek( 0x203, 4, (unsigned char *)&test );
  for ( rdp = 0x203; rdp < 0x23f; rdp += 0x04 )
    for ( csn = 1; csn < 10; csn++ )
      {
        gus_pnp_wake( csn );
        gus_pnp_peek( rdp, 9, (unsigned char *)&vendor );
        test = ( vendor[ 0 ] << 24 ) | ( vendor[ 1 ] << 16 ) | ( vendor[ 2 ] << 8 );
#if 0
        if ( *(unsigned int *)&vendor != 0xffffffff &&
             *(unsigned int *)&vendor != 0x00000000 )
          printk( "rdp port = 0x%x, csn = %i, vendor = 0x%02x%02x%02x%02x (requested 0x%x), serial = 0x%02x%02x%02x%02x, s = %i\n", 
          		rdp, csn,
          		vendor[ 0 ], vendor[ 1 ], vendor[ 2 ], vendor[ 3 ],
          		vendorID,
          		vendor[ 4 ], vendor[ 5 ], vendor[ 6 ], vendor[ 7 ],
          		vendor[ 4 ] | ( vendor[ 5 ] << 8 ) | ( vendor[ 6 ] << 16 ) | ( vendor[ 7 ] << 24 ) );
#endif
        if ( test == ( vendorID & 0xffffff00 ) )
          {
            if ( idx-- > 0 ) continue;	/* we are looking for another card */
            gus_pnp_wait();
            *rrdp = rdp;
            return csn;
          }
      }
  gus_pnp_wait();
  return 0;			/* not found or isolation needed */
}

static int gus_pnp_isol( int *rrdp )
{
  unsigned char checksum = 0x6a;
  unsigned char chksum = 0x00;
  unsigned char bit = 0x00;
  int rdp = 0x203;
  int data;
  int csn = 0;
  int i;
  int iteration = 1;
 
  gus_pnp_key();
  gus_pnp_wake( 0x00 );
  OUTB( 0x00, _PIDXR );
  OUTB( (unsigned char)(rdp>>2), _PNPWRP );
  OUTB( 0x01, _PIDXR );
  gus_delay1( 1 );
  
  while ( 1 )
    {
      for ( i = 1; i <= 64; i++ )
        {
          data = ((short)INB( rdp )) << 8;
          gus_delay1( 1 );
          data = data | INB( rdp );
          gus_delay1( 1 );
          if ( data == 0x55aa ) bit = 0x01;
          checksum = ((((checksum^(checksum>>1))&0x01)^bit)<<7)|(checksum>>1);
          bit = 0x00;
        }
      for ( i = 65; i <= 72; i++ )
        {
          data = ((short)INB( rdp )) << 8;
          gus_delay1( 1 );
          data = data | INB( rdp );
          gus_delay1( 1 );
          if ( data == 0x55aa ) chksum |= ( 1 << ( i - 65 ) );
        }
      if ( checksum != 0x00 && checksum == chksum )
        { 
          csn++;
          OUTB( 0x06, _PIDXR );
          OUTB( csn, _PNPWRP );
          iteration++;
          gus_pnp_wake( 0x00 );
          OUTB( 0x01, _PIDXR );
        }
      if ( ( checksum == 0x00 || chksum != checksum ) && iteration == 1 )
        {
          if ( rdp > 0x23f ) return -1;
          rdp += 0x04;
          checksum = 0x6a;
          chksum = 0x00;
          gus_pnp_wake( 0x00 );
          OUTB( 0x00, _PIDXR );
          OUTB( (unsigned char)(rdp >> 2), _PNPWRP );
          OUTB( 0x01, _PIDXR );
        }
      if ( ( checksum == 0x00 || chksum != checksum ) && iteration > 1 ) break;
      checksum = 0x6a;
      chksum = 0x00;
      bit = 0x00;
    }
  *rrdp = rdp;
  return csn;
}

static int cfg_byte( int rdp, unsigned char idx )
{
  OUTB( idx, _PIDXR );
  return INB( rdp );
}

static int cfg_word( int rdp, unsigned char idx )
{
  int val;

  OUTB( idx, _PIDXR );
  val = ((int)INB( rdp )) << 8;
  OUTB( idx + 1, _PIDXR );
  return val | INB( rdp );
}

static void gus_pnp_get_cfg( gus_card_t *card, int rdp )
{
  unsigned long flags;

  CLI( &flags );
  gus_pnp_device( PNP_DEV_AUDIO );
#if 0
  {
    static int x = 1;
    
    if ( x )
      {
        int i;
        printk( ">>> " );
        for ( i = 0; i < 256; i++ )
          printk( "%02x:", cfg_byte( rdp, i ) );
        printk( "\n" );
        x = 0;
      }
  }
#endif
  card -> gf1.port = cfg_word( rdp, 0x60 );
  card -> codec.port = cfg_word( rdp, 0x64 );
  card -> gf1.irq = cfg_byte( rdp, 0x70 ) & 0x0f;
  card -> dma1 = cfg_byte( rdp, 0x74 ) & 0x07;
  card -> dma2 = cfg_byte( rdp, 0x75 ) & 0x07;
  card -> equal_dma = card -> dma1 == card -> dma2;
#if 0
  printk( "get cfg: gf1p = 0x%x, codecp = 0x%x, irq = %i, dma1 = %i, dma2 = %i\n",
  		card -> gf1.port,
  		card -> codec.port,
  		card -> gf1.irq,
  		card -> dma1,
  		card -> dma2 );
#endif
  STI( &flags ); 
}

static void set_byte( unsigned char idx, unsigned char val )
{
  OUTB( idx, _PIDXR );
  OUTB( val, _PNPWRP ); 
}

static void set_word( unsigned char idx, unsigned short val )
{
  OUTB( idx, _PIDXR );
  OUTB( val >> 8, _PNPWRP );
  OUTB( idx + 1, _PIDXR );
  OUTB( (unsigned char)val, _PNPWRP );
}

static void gus_pnp_set_cfg( gus_card_t *card )
{
  unsigned long flags;

  CLI( &flags );
  gus_pnp_device( PNP_DEV_AUDIO );
  set_word( 0x60, card -> gf1.port );
  set_word( 0x62, card -> gf1.port + 0x100 );
  card -> codec.port = card -> gf1.port + 0x10c;
  set_word( 0x64, card -> codec.port );
  set_byte( 0x70, card -> gf1.irq );
  set_byte( 0x72, card -> gf1.irq );
  set_byte( 0x74, card -> dma1 );
  set_byte( 0x75, card -> dma2 );
#ifdef MPU401_TEST
  gus_pnp_device( PNP_DEV_MPU401 );
  set_word( 0x60, 0x330 );
  set_byte( 0x70, 9 );
#endif
#if 0 
  printk( "set cfg: gf1p = 0x%x, codecp = 0x%x, irq = %i, dma1 = %i, dma2 = %i\n",
  		card -> gf1.port,
  		card -> codec.port,
  		card -> gf1.irq,
  		card -> dma1,
  		card -> dma2 );
#endif
  STI( &flags );
}

int gus_pnp_look_for_cards( void )
{
  int idx, rdp, csn;

  idx = rdp = 0;
  if ( ( csn = gus_pnp_ping( &rdp, idx, PNP_ID_GRAVIS ) ) < 1 )
    {
#if 0
      PRINTK( "first ping failed\n" );
#endif
      gus_pnp_wait();
      gus_delay1( 10 );
      OUTB( 0x00, _PNPWRP );
      gus_delay1( 10 );
      gus_pnp_key();
      OUTB( 0x02, _PIDXR );
      OUTB( 0x04, _PNPWRP );
      gus_delay1( 10 );
      OUTB( 0x00, _PNPWRP );
      gus_delay1( 10 );
      gus_pnp_wait();
      if ( gus_pnp_isol( &rdp ) < 0 )
        return -1;
      if ( gus_pnp_ping( &rdp, idx, PNP_ID_GRAVIS ) < 1 )
        return -1;
    }
  for ( idx = 0; idx < 8; idx++ )
    if ( ( csn = gus_pnp_ping( &rdp, idx, PNP_ID_GRAVIS ) ) > 0 )
      {
        gus_pnp_key();
        gus_pnp_wake( csn );
        gus_pnp_activate( PNP_DEV_AUDIO, 0x00 );
        gus_pnp_activate( PNP_DEV_EXT, 0x00 );
        gus_pnp_activate( PNP_DEV_GAME, 0x00 );
        gus_pnp_activate( PNP_DEV_EMULATION, 0x00 );
        gus_pnp_activate( PNP_DEV_MPU401, 0x00 );
#if 0
        {
          gus_card_t acard;
          gus_pnp_get_cfg( &acard, rdp );
        }
#endif
        gus_pnp_wait();
      }
     else
      break;
  return idx;
}

int gus_pnp_look( gus_card_t *card, int idx )
{
  int rdp = 0, csn = 0;

  /* found the GUS PnP card.. */
  if ( ( csn = gus_pnp_ping( &rdp, idx, PNP_ID_GRAVIS ) ) < 1 ) return 0;
  gus_pnp_key();
  gus_pnp_wake( csn );
  gus_pnp_wait();
  card -> pnp_rdp = rdp;
  card -> pnp_csn = csn;
  return 1;				/* ok.. found, but not configured */
}

void gus_pnp_init( gus_card_t *card )
{
  gus_pnp_key();
  gus_pnp_wake( card -> pnp_csn );
  gus_pnp_activate( PNP_DEV_AUDIO, 0x00 );
  gus_pnp_set_cfg( card );
  gus_pnp_get_cfg( card, card -> pnp_rdp );
#if 0
  gus_pnp_power( 0xfe );
#endif
  gus_pnp_activate( PNP_DEV_AUDIO, 0x01 );
#ifdef MPU401_TEST
  gus_pnp_activate( PNP_DEV_MPU401, 0x01 );
#endif
  gus_pnp_wait();
  card -> pnp_flag = 1;
}

void gus_pnp_done( gus_card_t *card )
{
#if 1
  gus_pnp_key();
  gus_pnp_wake( card -> pnp_csn );
#if 0
  gus_pnp_power( 0x7e );
#endif
  gus_pnp_activate( PNP_DEV_AUDIO, 0 );
  gus_pnp_wait();
  card -> pnp_flag = 0;
#else
  static void gus_pnp_reset( gus_card_t *card );
  gus_pnp_reset( card );
#endif
}

#endif /* GUSCFG_PNP */
