/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 *  Effect support for InterWave (tm) chip
 */

#include <string.h>
#include "libgus.h"
#include "libgus_local.h"

/*
 *  defines
 */

 
/*
 *  structures
 */

struct effect {
  unsigned short voices;
  struct GUS_STRU_EFFECT_INTERWAVE *effects;
};

/*
 *  variables
 */

static struct GUS_STRU_EFFECT_INTERWAVE effect_1_room1[ 6 ] = {
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    0,							/* effect_number */
    0,							/* buffer_addr */
    0x0834,						/* buffer_size */
    0x0832,						/* buffer_pos */
    0x0f00,						/* volume */
    0x0fc3,						/* effect_volume */
    0x00de,						/* l_offset */
    0x0041,						/* r_offset */
    0xc05f,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0x4000,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x01,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    0,							/* effect_number */
    0,							/* buffer_addr */
    0x0a38,						/* buffer_size */
    0x0a36,						/* buffer_pos */
    0x0f00,						/* volume */
    0x0fb4,						/* effect_volume */
    0x0041,						/* l_offset */
    0x00de,						/* r_offset */
    0xc0be,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0x4000,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x02,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    0,							/* effect_number */
    0,							/* buffer_addr */
    0x0ccc,						/* buffer_size */
    0x0cca,						/* buffer_pos */
    0x0f00,						/* volume */
    0x0fa1,						/* effect_volume */
    0x00de,						/* l_offset */
    0x0041,						/* r_offset */
    0xc11d,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0x4000,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x04,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    0,							/* effect_number */
    0,							/* buffer_addr */
    0x0e28,						/* buffer_size */
    0x0e26,						/* buffer_pos */
    0x0f00,						/* volume */
    0x0f97,						/* effect_volume */
    0x0041,						/* l_offset */
    0x00de,						/* r_offset */
    0xc17c,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0x4000,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x08,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    0,							/* effect_number */
    0,							/* buffer_addr */
    0x0ef4,						/* buffer_size */
    0x0ef2,						/* buffer_pos */
    0x0f00,						/* volume */
    0x0f90,						/* effect_volume */
    0x00de,						/* l_offset */
    0x0041,						/* r_offset */
    0xc1db,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0x4000,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x10,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    0,							/* effect_number */
    0,							/* buffer_addr */
    0x1138,						/* buffer_size */
    0x1136,						/* buffer_pos */
    0x0f00,						/* volume */
    0x0f80,						/* effect_volume */
    0x0041,						/* l_offset */
    0x00de,						/* r_offset */
    0xc23a,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0x4000,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x20,						/* write_mask */
  }
};

static struct GUS_STRU_EFFECT_INTERWAVE effect_1_delay[ 2 ] = {
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    0,							/* effect_number */
    0,							/* buffer_addr */
    0x25c0,						/* buffer_size */
    0x25be,						/* buffer_pos */
    0x0f00,						/* volume */
    0x0e7c,						/* effect_volume */
    0x0080,						/* l_offset */
    0x0080,						/* r_offset */
    0xc05f,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0x4000,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x01,						/* write_mask */
  }
};

static struct GUS_STRU_EFFECT_INTERWAVE effect_1_panning_delay[ 2 ] = {
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    0,							/* effect_number */
    0,							/* buffer_addr */
    0x24c0,						/* buffer_size */
    0x24be,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0f00,						/* effect_volume */
    0x0fff,						/* l_offset */
    0x0000,						/* r_offset */
    0xc05f,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0x4000,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x02,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    0,							/* effect_number */
    0,							/* buffer_addr */
    0x24c0,						/* buffer_size */
    0x24be,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0f00,						/* effect_volume */
    0x0000,						/* l_offset */
    0x0fff,						/* r_offset */
    0xc0be,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0x4000,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x01,						/* write_mask */
  }
};

static struct effect effect_1[ 8 ] = {
  {
    /* Room 1 */
    6,
    &effect_1_room1[ 0 ]
  },
  {
    /* Room 2 */
    6,
    &effect_1_room1[ 0 ]
  },
  {
    /* Room 3 */
    6,
    &effect_1_room1[ 0 ]
  },
  {
    /* Hall 1 */
    6,
    &effect_1_room1[ 0 ]
  },
  {
    /* Hall 2 */
    6,
    &effect_1_room1[ 0 ]
  },
  {
    /* Plate */
    6,
    &effect_1_room1[ 0 ]
  },
  {
    /* Delay */
    1,
    &effect_1_delay[ 0 ]
  },
  {
    /* Panning Delay */
    2,
    &effect_1_panning_delay[ 0 ]
  }
};

static struct GUS_STRU_EFFECT_INTERWAVE effect_3_chorus1[ 2 ] = {
  {
    GUS_EFFECT_F_IW_USED,				/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x052c,						/* buffer_size */
    0x052a,						/* buffer_pos */
    0x0fb0,						/* volume */
    0x0000,						/* effect_volume */
    0x00de,						/* l_offset */
    0x0041,						/* r_offset */
    0xc02f,						/* vibrato_control */
    0x0050,						/* vibrato_depth */
    0xc1db,						/* tremolo_control */
    0x0333,						/* tremolo_depth */
    0x00,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED,				/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x0a2c,						/* buffer_size */
    0x0a2a,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0000,						/* effect_volume */
    0x0041,						/* l_offset */
    0x00de,						/* r_offset */
    0xd02f,						/* vibrato_control */
    0x0050,						/* vibrato_depth */
    0xd1db,						/* tremolo_control */
    0x0333,						/* tremolo_depth */
    0x00,						/* write_mask */
  }
};

static struct GUS_STRU_EFFECT_INTERWAVE effect_3_chorus2[ 2 ] = {
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x022c,						/* buffer_size */
    0x022a,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0e01,						/* effect_volume */
    0x00de,						/* l_offset */
    0x0041,						/* r_offset */
    0xc05f,						/* vibrato_control */
    0x05f3,						/* vibrato_depth */
    0xc05f,						/* tremolo_control */
    0x0eff,						/* tremolo_depth */
    0x80,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x022c,						/* buffer_size */
    0x022a,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0e01,						/* effect_volume */
    0x0041,						/* l_offset */
    0x00de,						/* r_offset */
    0xd05f,						/* vibrato_control */
    0x05f3,						/* vibrato_depth */
    0xd05f,						/* tremolo_control */
    0x0eff,						/* tremolo_depth */
    0x40,						/* write_mask */
  }
};

static struct GUS_STRU_EFFECT_INTERWAVE effect_3_chorus3[ 2 ] = {
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x052c,						/* buffer_size */
    0x052a,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0e01,						/* effect_volume */
    0x0129,						/* l_offset */
    0x0029,						/* r_offset */
    0xc020,						/* vibrato_control */
    0x0050,						/* vibrato_depth */
    0xc143,						/* tremolo_control */
    0x0eff,						/* tremolo_depth */
    0x80,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x06e8,						/* buffer_size */
    0x06e6,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0e01,						/* effect_volume */
    0x0029,						/* l_offset */
    0x0129,						/* r_offset */
    0xd020,						/* vibrato_control */
    0x0050,						/* vibrato_depth */
    0xd143,						/* tremolo_control */
    0x0eff,						/* tremolo_depth */
    0x40,						/* write_mask */
  }
};

static struct GUS_STRU_EFFECT_INTERWAVE effect_3_chorus4[ 2 ] = {
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x01a8,						/* buffer_size */
    0x01a6,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0f00,						/* effect_volume */
    0x00de,						/* l_offset */
    0x0041,						/* r_offset */
    0xc05f,						/* vibrato_control */
    0x04ef,						/* vibrato_depth */
    0xc05f,						/* tremolo_control */
    0x0eff,						/* tremolo_depth */
    0x80,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x024c,						/* buffer_size */
    0x024a,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0f00,						/* effect_volume */
    0x0041,						/* l_offset */
    0x00de,						/* r_offset */
    0xd05f,						/* vibrato_control */
    0x04ef,						/* vibrato_depth */
    0xd05f,						/* tremolo_control */
    0x0eff,						/* tremolo_depth */
    0x40,						/* write_mask */
  }
};

static struct GUS_STRU_EFFECT_INTERWAVE effect_3_feedback_chorus[ 2 ] = {
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x0a2c,						/* buffer_size */
    0x0a2a,						/* buffer_pos */
    0x0f00,						/* volume */
    0x0f00,						/* effect_volume */
    0x0352,						/* l_offset */
    0x0001,						/* r_offset */
    0xc02f,						/* vibrato_control */
    0x00fe,						/* vibrato_depth */
    0xc03f,						/* tremolo_control */
    0x0eff,						/* tremolo_depth */
    0x40,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x0a2c,						/* buffer_size */
    0x0a2a,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0f00,						/* effect_volume */
    0x0001,						/* l_offset */
    0x0352,						/* r_offset */
    0xd03f,						/* vibrato_control */
    0x00fe,						/* vibrato_depth */
    0xd03f,						/* tremolo_control */
    0x0eff,						/* tremolo_depth */
    0x80,						/* write_mask */
  }
};

static struct GUS_STRU_EFFECT_INTERWAVE effect_3_flanger[ 2 ] = {
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x0820,						/* buffer_size */
    0x081e,						/* buffer_pos */
    0x0fb0,						/* volume */
    0x0fb0,						/* effect_volume */
    0x0352,						/* l_offset */
    0x0001,						/* r_offset */
    0xc007,						/* vibrato_control */
    0x00fe,						/* vibrato_depth */
    0xc007,						/* tremolo_control */
    0x0eff,						/* tremolo_depth */
    0x40,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x0820,						/* buffer_size */
    0x081e,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0000,						/* effect_volume */
    0x0001,						/* l_offset */
    0x0352,						/* r_offset */
    0xd007,						/* vibrato_control */
    0x00fe,						/* vibrato_depth */
    0xd007,						/* tremolo_control */
    0x0eff,						/* tremolo_depth */
    0x80,						/* write_mask */
  }
};

static struct GUS_STRU_EFFECT_INTERWAVE effect_3_short_delay[ 2 ] = {
  {
    GUS_EFFECT_F_IW_USED,				/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x052c,						/* buffer_size */
    0x052a,						/* buffer_pos */
    0x0fb0,						/* volume */
    0x0000,						/* effect_volume */
    0x01a9,						/* l_offset */
    0x0013,						/* r_offset */
    0xc007,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0xc007,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x00,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED,				/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x14b0,						/* buffer_size */
    0x14ae,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0000,						/* effect_volume */
    0x0013,						/* l_offset */
    0x01a9,						/* r_offset */
    0xd007,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0xd007,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x00,						/* write_mask */
  }
};

static struct GUS_STRU_EFFECT_INTERWAVE effect_3_short_delay_fb[ 2 ] = {
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x052c,						/* buffer_size */
    0x052a,						/* buffer_pos */
    0x0fb0,						/* volume */
    0x0f80,						/* effect_volume */
    0x01a9,						/* l_offset */
    0x0013,						/* r_offset */
    0xc007,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0xc007,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x80,						/* write_mask */
  },
  {
    GUS_EFFECT_F_IW_USED | GUS_EFFECT_F_IW_ALTERNATE,	/* flags */
    2,							/* effect_number */
    0,							/* buffer_addr */
    0x14b0,						/* buffer_size */
    0x14ae,						/* buffer_pos */
    0x0fff,						/* volume */
    0x0f80,						/* effect_volume */
    0x0013,						/* l_offset */
    0x01a9,						/* r_offset */
    0xd007,						/* vibrato_control */
    0x0000,						/* vibrato_depth */
    0xd007,						/* tremolo_control */
    0x0000,						/* tremolo_depth */
    0x40,						/* write_mask */
  }
};

static struct effect effect_3[ 8 ] = {
  {
    /* Chorus 1 */
    2,
    &effect_3_chorus1[ 0 ]
  },
  {
    /* Chorus 2 */
    2,
    &effect_3_chorus2[ 0 ]
  },
  {
    /* Chorus 3 */
    2,
    &effect_3_chorus3[ 0 ]
  },
  {
    /* Chorus 4 */
    2,
    &effect_3_chorus4[ 0 ]
  },
  {
    /* Feedback Chorus */
    2,
    &effect_3_feedback_chorus[ 0 ]
  },
  {
    /* Flanger */
    2,
    &effect_3_flanger[ 0 ]
  },
  {
    /* Short Delay */
    2,
    &effect_3_short_delay[ 0 ]
  },
  {
    /* Short Delay - Feed Back */
    2,
    &effect_3_short_delay_fb[ 0 ]
  },  
};

/*
 *  functions
 */

int gus_effect_interwave( struct GUS_STRU_EFFECT *effect, int effect1, int effect3 )
{
  int voices, i;
  struct GUS_STRU_EFFECT_INTERWAVE *peff;

  if ( effect1 < -1 || effect1 > 7 ) return -1;
  if ( effect3 < -1 || effect3 > 7 ) return -1;
  if ( !effect ) return -1;
  memset( effect, 0, sizeof( effect ) );
  effect -> chip_type = GUS_EFFECT_CHIP_INTERWAVE;

  /* ok.. copy effect1 */
  if ( effect1 >= 0 )
    {
      voices = effect_1[ effect1 ].voices;
      peff = effect_1[ effect1 ].effects;
      for ( i = 0; i < voices; i++ )
        {
          effect -> chip.interwave.voice_output[ 0 ] |= 1 << i;
          memcpy( &effect -> chip.interwave.voices[ i ], &peff[ i ], sizeof( struct GUS_STRU_EFFECT_INTERWAVE ) );
        }
    }

  /* ok.. copy effect3 */
  if ( effect3 >= 0 )
    {
      voices = effect_3[ effect3 ].voices;
      peff = effect_3[ effect3 ].effects;
      for ( i = 0; i < voices; i++ )
        {
          effect -> chip.interwave.voice_output[ 2 ] |= 1 << ( 6 + i );
          memcpy( &effect -> chip.interwave.voices[ 6 + i ], &peff[ i ], sizeof( struct GUS_STRU_EFFECT_INTERWAVE ) );
        }
    }

  return 0;
}
