/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 *  Routines for GUS instrument allocation/free
 */

#include <malloc.h>
#include <string.h>
#include "libgus.h"
#include "libgus_local.h"

gus_instrument_t *gus_instr_alloc( void )
{
  gus_instrument_t *res;
  
  res = malloc( sizeof( *res ) );
  if ( res )
    memset( res, 0, sizeof( *res ) );
  return res;
}

static void free_iw_envelopes( struct GUS_STRU_IW_ENV_RECORD *record )
{
  struct GUS_STRU_IW_ENV_RECORD *orecord;

  while ( record )
    {
      orecord = record;
      record = record -> next;
      free( orecord -> points );
      free( orecord );
    }
}

int gus_instr_free( gus_instrument_t *instrument )
{
  gus_instrument_t *oinstrument;
  gus_layer_t *layer, *olayer;
  gus_wave_t *wave, *owave;

  while ( instrument )
    {
      oinstrument = instrument -> next;
      if ( !(instrument -> flags & GUS_INSTR_F_ALIAS) )
        {
          for ( layer = instrument -> info.layer; layer; layer = olayer )
            {
              olayer = layer -> next;
              if ( layer -> mode == GUS_INSTR_INTERWAVE )
                {
                  free_iw_envelopes( layer -> data.iw.penv.record );
                  free_iw_envelopes( layer -> data.iw.venv.record );
                }
              for ( wave = layer -> wave; wave; wave = owave )
                {
                  owave = wave -> next;
                  if ( !(wave -> format & (GUS_WAVE_ROM|GUS_WAVE_RAM)) )
                    free( wave -> begin.ptr );
                  free( wave );
                }
              free( layer );
            }
        }
      free( instrument -> name );
      free( instrument );
      instrument = oinstrument;
    }
  return 0;
}
