/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@astart.com>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * do_monitor.c,v 3.3 1998/03/29 23:03:05 papowell Exp
 */

#include "portable.h"
#include "hp4.h"
#include "common.h"

/*
 * set up the child process to do the monitoring and synchronizaiton
 */


void pr_ustatus(fd,pjlstr)
int fd;
char *pjlstr;
{
	int i = 0;
	query[i++]=pjlstr;
	pr_query(fd, i);
}

void do_monitor()
{
	int printer_code;
	int n, err;
	char buf[MAXLINE+1];
	int i = 0;

	header_info();
	printer_ok = TRUE;
	if( get_status ){
		/*
		* Try to synchronise with printer; use 60 secs as good default
		*/
		if( sync_printer ){
			if( pr_synch(STDOUT, 60 )==FALSE ){
				log(2,"Failed to synchronise with printer");
				fexit(FILTRETRY);
			}
			/* send the start of job string */
			i = 0;
			plp_snprintf(buf,sizeof(buf)-1,"@PJL JOB %s\r\n", job_start);
			query[i++] = buf;
			log(4, "do_monitor: starting");
			pr_query(STDOUT, i);
		}

	   /*
		* Check printer status
		*/
		if( infostatus ){
			do {
				printer_ok = FALSE;
				printer_code = 0;
				pr_ustatus(STDOUT, INFOSTATUS);	/* job status on */
				err = readpipe( &printer_code,4);
				n = printer_code/1000; /* code group */
				if( err < 0 ){
					log (2, "EOF reading from printer");
					fexit(FILTABORT);
				} else if( err != 0
					&& (n == 10 || n == 11 || printer_code == 35078 ) ){
					/*
					* These printer codes indicate that it is
					* safe to print:
					*
					* 10xxx: Informational messages.
					* 11xyy: Background Paper Mount (paper is out in some
					*        tray, but the same format is available in
					*        another tray).
					* 35078: Entered powersave mode.
					*/
					printer_ok = TRUE;
				}
			} while( printer_ok==FALSE );
		}
		/* get initial page count */
		if( pagecount ){
			initialpagecount = pr_pagecount(STDOUT);
			if( initialpagecount < 0 ){
				log (2, "Pagecount not found using PJL INFO.");
			}
		}
		if( (initialpagecount < 0 || forcepagecount) && cartridge ) {
			initialpagecount = pr_pspagecount(STDOUT);
			if (initialpagecount < 0){
				log (2, "Pagecount not found using PostScript");
			}
		}
		/* set up reading of status information */
		if( infostatus ){
			create_monitor();
			log(4,"Father pid=%d, child %d",getpid(), monitpid );
		}
	}

	log(2,"Initial page count %d", initialpagecount );
}

void create_monitor()
{
	int n, pid;

	/* pr_ustatus(STDOUT,"@PJL USTATUS DEVICE = VERBOSE\r\n"); */
	monitpid = fork();
	log(4,"Right after fork, pid %d with monitpid=%d",
		getpid(), monitpid);
	if( monitpid == -1 ){
		logerr(1,"Cannot fork process");
		fexit(FILTABORT);
	} else if( monitpid == 0 ){
		pid = getppid();
		log(4,"Child with pid=%d, parent %d", getpid(), pid);
		while(1){
			fd_set readfds;
			FD_ZERO( &readfds );
			FD_SET( STDOUT, &readfds );
			/* desperation check for parent exiting under
				core dump type or where no killpg() done */
			if( kill(pid,0) == -1 ){
				exit(0);
			}
			log(4,"Child starting select");
			n = select( STDOUT+1, &readfds, (void *)0, (void *)0,
				(void *)0 );
			log(4,"Child select returns %d", n);
			if( n > 0 ){
				log(4,"Child getting status");
				n = readpipe((int *)0, 30 );
				if( n < 0 ) break;
			} else if( n == -1 && errno != EINTR ){
				break;
			}
		}
		log(4,"Exit child with pid=%d",getpid() );
		exit(0);
	}
}
