# print.tcl --
#
# Handles printing of a message
#
#
#  TkRat software and its included text is Copyright 1996,1997,1998
#  by Martin Forssn
#
#  Postilion software and its included text and images
#  Copyright (C) 1998 Nic Bernstein
#
#  The full text of the legal notices is contained in the files called
#  COPYING and COPYRIGHT.TkRat, included with this distribution.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Print --
#
# Prints messages.
#
# Arguments:
# handler -	Handler of the corresponding folder command
# which	  -	Which messages that should be printed "group" or "selected"

proc Print {handler which} {
    global option

    foreach msg [GetMsgSet $handler $which] {
	set fileName $option(tmp)/rat.[RatGenId]
	set tmpFH [open $fileName w]
	# headers
	switch $option(print_header) {
	all	{
		foreach h [$msg headers full] {
		    puts $tmpFH "[lindex $h 0]: [lindex $h 1]"
		}
		puts $tmpFH ""
	    }
	selected {
		foreach h [$msg headers full] {
		    set header([string tolower [lindex $h 0]]) [lindex $h 1]
		}
		foreach f $option(show_header_selection) {
		    set n [string tolower $f]
		    if [info exists header($n)] {
			puts $tmpFH "$f: $header($n)"
		    }
		}
		unset header
		puts $tmpFH ""
	    }
	default	{ }
	}
	[$msg body] saveData $tmpFH 0 1
	close $tmpFH
	DoPrint $fileName
    }
}

# DoPrint --
#
# Actually does the printing
#
# Arguments:
# fileName  - The name of the file to print

proc DoPrint {fileName} {
    global option idCnt env

    # Create identifier
    set id print[incr idCnt]
    global $id
    set ${id}(fileName) $fileName

    if { 0 == [regsub "%s" $option(print_command) $fileName cmd]} {
	set cmd "cat $fileName | $option(print_command)"
    }
    regsub {^~/} $cmd $env(HOME)/ cmd
    regsub {[ 	]~/} $cmd " $env(HOME)/" cmd
    RatBgExec ${id}(exitStatus) $cmd
    uplevel #0 "trace variable ${id}(exitStatus) w PrintDone"
}

# PrintDone --
#
# Is called by the trace callback when the print command is done. It is
# meant to do any cleaning up.
#
# Arguments:
# name1, name2 -	Variable specifiers
# op	       -	Operation

proc PrintDone {name1 name2 op} {
    upvar #0 $name1 pr

    file delete -force -- $pr(fileName) &
    unset pr
}
