/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    A pix_texture

    Copyright (c) 1997-1998 Mark Danks. mark@danks.org
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_PIX_TEXTURE_H_
#define INCLUDE_PIX_TEXTURE_H_

#include "Base/GemBase.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    pix_texture
    
    Turns on texture mapping

KEYWORDS
    pix
    
DESCRIPTION

-----------------------------------------------------------------*/
class GEM_EXTERN pix_texture : public GemBase
{
    CPPEXTERN_HEADER(pix_texture, GemBase)

    public:

        //////////
        // Constructor
    	pix_texture();
    	
    protected:
    	
    	//////////
    	// Destructor
    	virtual ~pix_texture();

    	//////////
    	// Do the rendering
    	virtual void 	render(GemState *state);

    	//////////
    	// Turn back off texture mapping
    	virtual void 	postrender(GemState *state);

    	//////////
    	// Establish texture object
    	virtual void	startRendering();

    	//////////
    	// Delete texture object
    	virtual void	stopRendering();
    	
        //////////
        // Turn on/off texture mapping
        void            textureOnOff(int on);

		//////////
		// Set up the texture state
		void			setUpTextureState();

        //////////
        int             m_textureOnOff;

        //////////
        GLuint			m_textureQuality;

        //////////
        // Set the texture quality
        // [in] type - if == 0, then GL_NEAREST, else GL_LINEAR
        void            textureQuality(int type);

        //////////
        // Do we need to rebuild the display List
        int             m_rebuildList;

    	//////////
    	// The texture object number
    	GLuint	    	m_textureObj;
    	
	private:

    	//////////
    	// static member functions
    	static void 	floatMessCallback(void *data, float n);
    	static void 	textureMessCallback(void *data, t_floatarg n);
};

#endif	// for header file
