////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// mark@danks.org
//
// Implementation file
//
//    Copyright (c) 1997-1998 Mark Danks.
//    For information on usage and redistribution, and for a DISCLAIMER OF ALL
//    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.
//
/////////////////////////////////////////////////////////

#include "fillback.h"

#include <math.h>

#include "Base/GemState.h"

CPPEXTERN_NEW_WITH_TWO_ARGS(fillback, t_floatarg, A_DEFFLOAT, t_floatarg, A_DEFFLOAT)

/////////////////////////////////////////////////////////
//
// fillback
//
/////////////////////////////////////////////////////////
// Constructor
//
/////////////////////////////////////////////////////////
fillback :: fillback(t_floatarg width, t_floatarg height)
        : GemShape(1.f), m_width(width), m_height(height)
{
    m_drawType = GL_QUADS;
}

/////////////////////////////////////////////////////////
// Destructor
//
/////////////////////////////////////////////////////////
fillback :: ~fillback()
{ }

/////////////////////////////////////////////////////////
// render
//
/////////////////////////////////////////////////////////
void fillback :: render(GemState *state)
{
//    glNormal3d(0.0, 0.0, 1.0);

	static double lastTime1 = clock_getsystime();
	static double lastTime2 = clock_getsystime();
	static double sysToMilli = clock_gettimesince(clock_getsystime() - 1);

	double cur1Time = clock_gettimesince(lastTime1);
	double cur2Time = clock_gettimesince(lastTime2);

	float period = 60.f * 1000.f;
	while (cur1Time > period)
	{
		cur1Time -= period;
		lastTime1 += (period / sysToMilli);
	}

	double amount = cur1Time / period;
	const double TWO_PI = 3.1415926535 * 2.;
	float val1 = (float)sin(amount * TWO_PI) / 2.f;
	period = 54.f * 1000.f;
	while (cur2Time > period)
	{
		cur2Time -= period;
		lastTime2 += (period / sysToMilli);
	}
	amount = cur2Time / period;
	float val2 = (float)sin(amount * TWO_PI) / 2.f;

	
	if (state->lighting)
		glDisable(GL_LIGHTING);

    glBegin(GL_QUADS);
        glTexCoord2f(val1, val2);
            glVertex3f(-m_width, -m_height, 0.0f);
        glTexCoord2f(1.0f + val1, val2);
            glVertex3f( m_width, -m_height, 0.0f);
        glTexCoord2f(1.0f + val2, 1.0f + val2);
            glVertex3f( m_width,  m_height, 0.0f);
        glTexCoord2f(val1, 1.0f + val2);
			glVertex3f(-m_width,  m_height, 0.0f);
    glEnd();

	if (state->lighting)
		glEnable(GL_LIGHTING);
}

/////////////////////////////////////////////////////////
// typeMess
//
/////////////////////////////////////////////////////////
void fillback :: typeMess(t_symbol *)
{ }

/////////////////////////////////////////////////////////
// static member function
//
/////////////////////////////////////////////////////////
void fillback :: obj_setupCallback(t_class *)
{ }

