/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    read in a model file

    Copyright (c) 1997-1998 Mark Danks. mdanks@cybermed.ucsd.edu
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_MODEL_H_
#define INCLUDE_MODEL_H_

#include "Base/GemBase.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    model
    
    read in a model file

DESCRIPTION

    Inlet for a list - "model"

    "open" - the RGB model to set the object to
    
-----------------------------------------------------------------*/
class GEM_EXTERN model : public GemBase
{
    CPPEXTERN_HEADER(model, GemBase)

    public:

	    //////////
	    // Constructor
    	model(t_symbol *filename);
    	
    protected:
    	
    	//////////
    	// Destructor
    	virtual ~model();

    	//////////
    	// When an open is received
    	virtual void	openMess(t_symbol *filename);
    	
    	//////////
    	void	    	cleanModel();
    	
    	//////////
    	virtual void	render(GemState *state);

    	//////////
    	GLint	    	m_dispList;
    	
    private:
    
    	//////////
    	// static member functions
    	static void 	openMessCallback(void *data, t_symbol *filename);
 };

#endif	// for header file
