////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// mdanks@cybermed.ucsd.edu
//
// Implementation file
//
//    Copyright (c) 1997-1998 Mark Danks.
//    For information on usage and redistribution, and for a DISCLAIMER OF ALL
//    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.
//
/////////////////////////////////////////////////////////

#include "curve.h"

#include <string.h>

CPPEXTERN_NEW_WITH_ONE_ARG(curve, t_floatarg, A_FLOAT)

/////////////////////////////////////////////////////////
//
// curve
//
/////////////////////////////////////////////////////////
// Constructor
//
/////////////////////////////////////////////////////////
curve :: curve(t_floatarg numInputs)
	   : polygon(numInputs)
{
    m_drawType = GL_LINE_STRIP;
    m_resolution = 30;
}

/////////////////////////////////////////////////////////
// Destructor
//
/////////////////////////////////////////////////////////
curve :: ~curve()
{ }

/////////////////////////////////////////////////////////
// render
//
/////////////////////////////////////////////////////////
void curve :: render(GemState *)
{
    glNormal3d(0.0, 0.0, 1.0);
    glLineWidth(m_linewidth);
    glMap1f(GL_MAP1_VERTEX_3, 0.0, 1.0, 3, m_numInputs, &(m_vert[0][0]));
    glEnable(GL_MAP1_VERTEX_3);
    glBegin(m_drawType);
	    for (int n = 0; n < m_resolution; n++)
	        glEvalCoord1f((GLfloat)n/(float)m_resolution);
    glEnd();
    glLineWidth(1.0);
}

/////////////////////////////////////////////////////////
// resolutionMess
//
/////////////////////////////////////////////////////////
void curve :: resolutionMess(int resolution)
{
    m_resolution = (resolution < 1) ? 1 : resolution;
    setModified();
}

/////////////////////////////////////////////////////////
// typeMess
//
/////////////////////////////////////////////////////////
void curve :: typeMess(t_symbol *type)
{
    if (!strcmp(type->s_name, "line")) 
	    m_drawType = GL_LINE_STRIP;
    else if (!strcmp(type->s_name, "point"))
	    m_drawType = GL_POINTS;
    else
    {
	    error("GEM: curve draw style");
	    return;
    }
    setModified();
}

/////////////////////////////////////////////////////////
// static member function
//
/////////////////////////////////////////////////////////
void curve :: obj_setupCallback(t_class *classPtr)
{
    class_addmethod(classPtr, (t_method)&curve::resolutionMessCallback,
    	    gensym("res"), A_FLOAT, A_NULL);
}
void curve :: resolutionMessCallback(void *data, t_floatarg res)
{
    GetMyClass(data)->resolutionMess((int)res);
}
