/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    A camera object

    Copyright (c) 1997-1998 Mark Danks. mark@danks.org
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_CAMERA_H_
#define INCLUDE_CAMERA_H_

#include "Base/GemBase.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    camera
    
    A camera object

DESCRIPTION

    Inlet for a float - "ft1"
    Inlet for a list  - "rotatelist"
    Inlet for a float - "ft2"
    Inlet for a list  - "translatelist"
    Inlet for a list  - "looklist"

    "ft1" - rotation angle
    "rotatelist" - rotation vector
    "ft2" - translation amount
    "translatelist" - translation vector
    "looklist" - lookat point
    "reset" - reset the camera values
    "print" - print out the camera values
    
-----------------------------------------------------------------*/
class GEM_EXTERN camera : public GemBase
{
    CPPEXTERN_HEADER(camera, GemBase)

    public:

        //////////
        // Constructor
    	camera();
    	
    protected:
    	
    	//////////
    	// Destructor
    	virtual     	~camera();

    	//////////
    	// When rendering occurs
    	virtual void	render(GemState *state);

    	//////////
    	// Print out the camera values
    	void	    	printMess();
    	
    	//////////
    	// Reset the camera values
    	void	    	resetMess();
    	
    	//////////
    	// Does the actual job of reseting the camera values
    	void	    	resetValues();
    	
    	//////////
    	// The angle of rotation
    	void	    	rotAngleMess(float angle);
    	
    	//////////
    	// The vector of rotation
    	void	    	rotVectorMess(float x, float y, float z);
    	
    	//////////
    	// The amount of translation
    	void	    	transAmountMess(float amount);
    	
    	//////////
    	// The vector of translation
    	void	    	transVectorMess(float x, float y, float z);
    	
    	//////////
    	// The look at point
    	void	    	lookVectorMess(float x, float y, float z);
    	
    	//////////
    	// Rotate vector
    	float	    	m_spin[3];
    	
    	//////////
    	// Rotation angle
    	float	    	m_angle;
    	
    	//////////
    	// Translation vector
    	float	    	m_pos[3];
    	
    	//////////
    	// Translation amount
    	float	    	m_trans;
    	
    	//////////
    	// Look at point
    	float	    	m_look[3];
    	
    private:
    
    	//////////
    	// Static member functions
    	static void 	rotAngleMessCallback(void *data, t_floatarg angle);
    	static void 	rotVectorMessCallback(void *data, t_floatarg x, t_floatarg y, t_floatarg z);
    	static void 	transAmountMessCallback(void *data, t_floatarg amount);
    	static void 	transVectorMessCallback(void *data, t_floatarg x, t_floatarg y, t_floatarg z);
    	static void 	lookVectorMessCallback(void *data, t_floatarg x, t_floatarg y, t_floatarg z);
    	static void 	resetMessCallback(void *data);
    	static void 	printMessCallback(void *data);
};

#endif	// for header file
