/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    An object which accepts two pixes.

    Copyright (c) 1997-1998 Mark Danks. mdanks@cybermed.ucsd.edu
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_GEMPIXDUALOBJ_H_
#define INCLUDE_GEMPIXDUALOBJ_H_

#include "Base/GemPixObj.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    GemPixDualObj
    
    An object which accepts two pixes.

DESCRIPTION

    Inlet for a gem - "gem_right"
    
    "gem_right" - The second gem list
   
-----------------------------------------------------------------*/
class GEM_EXTERN GemPixDualObj : public GemPixObj
{
    public:

        //////////
        // Constructor
    	GemPixDualObj();
    	
    protected:
    	
    	//////////
    	// Destructor
    	virtual ~GemPixDualObj();

    	//////////
		// Derived classes should NOT override this!
		// This makes sure that the images are the same size.  If you
		//		don't care about the size, then you will need to override this.
    	// Do the processing - this calls the other process functions
    	virtual void 	processImage(imageStruct &image);

    	//////////
    	// The derived class SHOULD override this.
    	//  This is called whenever a new image comes through.
		//	Both of the image structs are RGBA
    	virtual void 	processDualImage(imageStruct &image, imageStruct &right) = 0;
    	
    	//////////
    	// The derived class CAN override this.
    	//  This is called whenever a new image comes through.
    	//	Both of the image structs are gray8
		virtual void 	processBothGray(imageStruct &image, imageStruct &right);
    	
    	//////////
    	// The derived class CAN override this.
    	//  This is called whenever a new image comes through.
		//	The left image is an RGBA, the right is a gray8
    	virtual void 	processRightGray(imageStruct &image, imageStruct &right);
    	
    	//////////
    	// The derived class CAN override this.
    	//  This is called whenever a new image comes through.
		//	The left image is a gray8, the right is an RGBA
    	virtual void 	processLeftGray(imageStruct &image, imageStruct &right);
    	
    	//////////
    	virtual void	stopRendering();

    	//////////
    	virtual void   	rightRender(GemState *state);

    	//////////
    	virtual void   	rightPostrender(GemState *)    	{ }

    	//////////
    	GemCache    	*m_cacheRight;

    	//////////
    	pixBlock    	*m_pixRight;

    	//////////
        void	    	rightDagCacheMess(GemDag *dagPtr, GemCache *cachePtr);

        //////////
        t_inlet         *m_inlet;

    	//////////
    	// creation callback
    	static void 	real_obj_setupCallback(t_class *classPtr)
    	    { GemPixObj::real_obj_setupCallback(classPtr); GemPixDualObj::obj_setupCallback(classPtr); }
    	
  private:
    
     	static inline GemPixDualObj *GetMyClass(void *data) {return((GemPixDualObj *)((Obj_header *)data)->data);}

    	//////////
    	// Static member functions
    	static void 	obj_setupCallback(t_class *classPtr);
    	static void 	rightDagCacheMessCallback(void *x, void *gem_dag, void *gem_cache);
    	static void 	rightRenderCallback(GemBase *data, GemState *state);
    	static void 	rightPostrenderCallback(GemBase *data, GemState *state);
};

#endif	// for header file
