#include <sys/malloc.h>

BYTE free( void *ptr)
{
	/* Do a relativly safe free by only freeing vaild used hunks */
	pmmalloc_hunk thisHunk;

	thisHunk = malloc_first;

	ptr = (void *)((UWORD)ptr - sizeof(mmalloc_hunk));
	
	while (thisHunk && (thisHunk->magic==MALLOC_MAGIC)) {
		if (thisHunk == ptr) {
			debug("free", "Found hunk");
			if (thisHunk->status == MALLOC_USED) {
				thisHunk->status = MALLOC_FREE;
				return 0;
			}
			debug("free", "Attempt to free a free hunk");
			return -1;
		}
		thisHunk = thisHunk->next;
	};

	debug("free", "No hunk found");
	return -2;
}
