#ifndef _HARDWARE_H
#define _HARDWARE_H

#define P1_REG		_reg_0x00	/* Joystick: 1.1.P15.P14.P13.P12.P11.P10 */
#define SB_REG		_reg_0x01	/* Serial IO data buffer */
#define SC_REG		_reg_0x02	/* Serial IO control register */
#define DIV_REG		_reg_0x04	/* Divider register */
#define TIMA_REG	_reg_0x05	/* Timer counter */
#define TMA_REG		_reg_0x06	/* Timer modulo */
#define TAC_REG		_reg_0x07	/* Timer control */
#define IF_REG		_reg_0x0F	/* Interrupt flags: 0.0.0.JOY.SIO.TIM.LCD.VBL */
#define NR10_REG	_reg_0x10	/* Sound register */
#define NR11_REG	_reg_0x11	/* Sound register */
#define NR12_REG	_reg_0x12	/* Sound register */
#define NR13_REG	_reg_0x13	/* Sound register */
#define NR14_REG	_reg_0x14	/* Sound register */
#define NR21_REG	_reg_0x16	/* Sound register */
#define NR22_REG	_reg_0x17	/* Sound register */
#define NR23_REG	_reg_0x18	/* Sound register */
#define NR24_REG	_reg_0x19	/* Sound register */
#define NR30_REG	_reg_0x1A	/* Sound register */
#define NR31_REG	_reg_0x1B	/* Sound register */
#define NR32_REG	_reg_0x1C	/* Sound register */
#define NR33_REG	_reg_0x1D	/* Sound register */
#define NR34_REG	_reg_0x1E	/* Sound register */
#define NR41_REG	_reg_0x20	/* Sound register */
#define NR42_REG	_reg_0x21	/* Sound register */
#define NR43_REG	_reg_0x22	/* Sound register */
#define NR44_REG	_reg_0x23	/* Sound register */
#define NR50_REG	_reg_0x24	/* Sound register */
#define NR51_REG	_reg_0x25	/* Sound register */
#define NR52_REG	_reg_0x26	/* Sound register */
#define LCDC_REG	_reg_0x40	/* LCD control */
#define STAT_REG	_reg_0x41	/* LCD status */
#define SCY_REG		_reg_0x42	/* Scroll Y */
#define SCX_REG		_reg_0x43	/* Scroll X */
#define LY_REG		_reg_0x44	/* LCDC Y-coordinate */
#define LYC_REG		_reg_0x45	/* LY compare */
#define DMA_REG		_reg_0x46	/* DMA transfer */
#define BGP_REG		_reg_0x47	/* BG palette data */
#define OBP0_REG	_reg_0x48	/* OBJ palette 0 data */
#define OBP1_REG	_reg_0x49	/* OBJ palette 1 data */
#define WY_REG		_reg_0x4A	/* Window Y coordinate */
#define WX_REG		_reg_0x4B	/* Window X coordinate */
#define KEY1_REG	_reg_0x4D	/* CPU speed */
#define VBK_REG		_reg_0x4F	/* VRAM bank */
#define HDMA1_REG	_reg_0x51	/* DMA control 1 */
#define HDMA2_REG	_reg_0x52	/* DMA control 2 */
#define HDMA3_REG	_reg_0x53	/* DMA control 3 */
#define HDMA4_REG	_reg_0x54	/* DMA control 4 */
#define HDMA5_REG	_reg_0x55	/* DMA control 5 */
#define RP_REG		_reg_0x56	/* IR port */
#define BCPS_REG	_reg_0x68	/* BG color palette specification */
#define BCPD_REG	_reg_0x69	/* BG color palette data */
#define OCPS_REG	_reg_0x6A	/* OBJ color palette specification */
#define OCPD_REG	_reg_0x6B	/* OBJ color palette data */
#define SVBK_REG	_reg_0x70	/* WRAM bank */
#define IE_REG		_reg_0xFF	/* Interrupt enable */

extern UBYTE P1_REG;
extern UBYTE SB_REG;
extern UBYTE SC_REG;
extern UBYTE DIV_REG;
extern UBYTE TIMA_REG;
extern UBYTE TMA_REG;
extern UBYTE TAC_REG;
extern UBYTE IF_REG;
extern UBYTE NR10_REG;
extern UBYTE NR11_REG;
extern UBYTE NR12_REG;
extern UBYTE NR13_REG;
extern UBYTE NR14_REG;
extern UBYTE NR21_REG;
extern UBYTE NR22_REG;
extern UBYTE NR23_REG;
extern UBYTE NR24_REG;
extern UBYTE NR30_REG;
extern UBYTE NR31_REG;
extern UBYTE NR32_REG;
extern UBYTE NR33_REG;
extern UBYTE NR34_REG;
extern UBYTE NR41_REG;
extern UBYTE NR42_REG;
extern UBYTE NR43_REG;
extern UBYTE NR30_REG;
extern UBYTE NR50_REG;
extern UBYTE NR51_REG;
extern UBYTE NR52_REG;
extern UBYTE LCDC_REG;
extern UBYTE STAT_REG;
extern UBYTE SCY_REG;
extern UBYTE SCX_REG;
extern UBYTE LY_REG;
extern UBYTE LYC_REG;
extern UBYTE DMA_REG;
extern UBYTE BGP_REG;
extern UBYTE OBP0_REG;
extern UBYTE OBP1_REG;
extern UBYTE WY_REG;
extern UBYTE WX_REG;
extern UBYTE KEY1_REG;
extern UBYTE VBK_REG;
extern UBYTE HDMA1_REG;
extern UBYTE HDMA2_REG;
extern UBYTE HDMA3_REG;
extern UBYTE HDMA4_REG;
extern UBYTE HDMA5_REG;
extern UBYTE RP_REG;
extern UBYTE BCPS_REG;
extern UBYTE BCPD_REG;
extern UBYTE OCPS_REG;
extern UBYTE OCPD_REG;
extern UBYTE SVBK_REG;
extern UBYTE IE_REG;

extern UBYTE _reg_0x10;
extern UBYTE _reg_0x11;
extern UBYTE _reg_0x12;
extern UBYTE _reg_0x13;
extern UBYTE _reg_0x14;
extern UBYTE _reg_0x15;
extern UBYTE _reg_0x16;
extern UBYTE _reg_0x17;
extern UBYTE _reg_0x18;
extern UBYTE _reg_0x19;
extern UBYTE _reg_0x1A;
extern UBYTE _reg_0x1B;
extern UBYTE _reg_0x1C;
extern UBYTE _reg_0x1D;
extern UBYTE _reg_0x1E;
extern UBYTE _reg_0x1F;
extern UBYTE _reg_0x20;
extern UBYTE _reg_0x21;
extern UBYTE _reg_0x22;
extern UBYTE _reg_0x23;
extern UBYTE _reg_0x24;
extern UBYTE _reg_0x25;
extern UBYTE _reg_0x26;

#endif /* _HARDWARE_H */
