/* Modified for JTeX by Takafumi Sakurai 1998. */

/* help.h: help messages for web2c programs.

   This is included by everyone, from cpascal.h.  This is better than
   putting the help messages directly in the change files because (1)
   multiline strings aren't supported by tangle, and it would be a pain
   to make up a new syntax for them in web2c, and (2) when a help msg
   changes, we need only recompile, not retangle or reconvert.  The
   downside is that everything gets recompiled when any msg changes, but
   that's better than having umpteen separate tiny files.  (For one
   thing, the messages have a lot in common, so it's nice to have them
   in one place.)

Copyright (C) 1995, 96 Karl Berry.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef HELP_H
#define HELP_H

#ifdef BIBTEX
#define BIBTEXHELP \
"Usage: jbibtex [OPTION]... AUXFILE[.aux]\n\
  Write bibliography for entries in AUXFILE to AUXFILE.bbl.\n\
\n\
-min-crossrefs=NUMBER  include item after NUMBER cross-refs; default 2\n\
-terse                 do not print progress reports\n\
-help                  display this help and exit\n\
-version               output version information and exit\n"
#endif /* BIBTEX */

#ifdef TeX
#define TEXHELP \
"Usage: jtex [OPTION]... [TEXNAME[.tex]] [COMMANDS]\n\
   or: jtex [OPTION]... \\FIRST-LINE\n\
   or: jtex [OPTION]... &FMT ARGS\n\
  Run JTeX on TEXNAME, usually creating TEXNAME.dvi.\n\
  Any remaining COMMANDS are processed as JTeX input, after TEXNAME is read.\n\
  If the first line of TEXNAME is %&FMT, and FMT is an existing .fmt file,\n\
  use it; %&ini means inijtex.  Else use `NAME.fmt', where NAME is the program\n\
  invocation name, most commonly `jtex'.\n\
\n\
  Alternatively, if the first non-option argument begins with a backslash,\n\
  interpret all non-option arguments as a line of JTeX input.\n\
\n\
  Alternatively, if the first non-option argument begins with a &, the\n\
  next word is taken as the FMT to read, overriding all else.  Any\n\
  remaining arguments are processed as above.\n\
\n\
  If no arguments or options are specified, prompt for input.\n\
\n\
-code=CODE               specify the default code (CODE=ascii/jis/euc/sjis)\n\
-fmt=FMTNAME             use FMTNAME instead of program name or a %& line\n\
-ini                     be inijtex, for dumping formats; this is implicitly\n\
                          true if the program name is `initex'\n\
-interaction=STRING      set interaction mode (STRING=batchmode/nonstopmode/\n\
                          scrollmode/errorstopmode)\n\
-kpathsea-debug=NUMBER   set path searching debugging flags according to\n\
                          the bits of NUMBER\n\
[-no]-mktex=FMT          disable/enable mktexFMT generation (FMT=tex/tfm)\n\
-mltex                   enable MLTeX extensions such as \\charsubdef\n\
-output-comment=STRING   use STRING for DVI file comment instead of date\n\
-progname=STRING         set program (and fmt) name to STRING\n\
-shell-escape            enable \\write18{SHELL COMMAND}\n\
-help                    display this help and exit\n\
-version                 output version information and exit\n"
#ifdef IPC
#define TEX_IPC_HELP \
"-ipc                     send DVI output to a socket as well as the usual\n\
                          output file\n\
-ipc-start               as -ipc, and also start the server at the other end\n"
#endif /* IPC */
#endif /* TeX */
/* TCX files are probably a bad idea.
-translate-file=TCXFILE  use TCXFILE for printable chars and translations\n\
*/

#endif /* not HELP_H */
