#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "npnews.h"

int NP_News::get_requests()
{
   if ( get_requests_list())
      return 1;

   if ( !total_requests )
   {
      destroy_requests_list();
      return 0;
   }

   char *ignored = change_group( NULL );
   if ( ignored == NULL )
   {
      destroy_requests_list();
      return 1;
   }

   NP_File spool, read;

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s", home,
             address, group );
   if ( spool.opena( buffer ))
   {
      destroy_requests_list();
      snprintf( error_message, sizeof error_message, "NP_News: "
                "get_requests(): %s", spool.get_error());
      return 1;
   }

   strcat( buffer, ":read" );
   if ( read.opena( buffer ))
   {
      destroy_requests_list();
      snprintf( error_message, sizeof error_message, "NP_News: "
                "get_requests(): %s", read.get_error());
      return 1;
   }

   np_requests_list_t *pointer = requests_list;
   for( int i = 0; i < total_requests; ++i )
   {
      snprintf( buffer, sizeof buffer, "article %s\r\n", pointer->request );
      if ( put_string( buffer ))
         return 1;
      ++pointer;
   }

   pointer = requests_list;
   for( int i = 0; i < total_requests; ++i )
   {
      if ( stop )
      {
         spool.close();
         read.close();
         remove_headers();
         destroy_requests_list();
         strcpy( error_message,
                 "NP_News: get_requests(): killed by SIGTERM." );
         return 1;
      }

      if ( get_string( buffer, sizeof buffer ))
      {
         spool.close();
         read.close();
         remove_headers();
         destroy_requests_list();
         return 1;
      }

      switch( check_response( buffer ))
      {
      case 0:
         break;

      case 1:
         spool.close();
         read.close();
         remove_headers();
         destroy_requests_list();
         return 1;

      case 2:
         continue;
         break;
      }

      pointer++->found = 1;

      do
      {
         if ( get_string( buffer, sizeof buffer ))
         {
            destroy_requests_list();
            return 1;
         }

         if ( spool.put_string( buffer ))
         {
            spool.close();
            read.close();
            remove_headers();
            destroy_requests_list();
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "get_requests(): %s", spool.get_error());
            return 1;
         }
      }
      while( strncmp( buffer, ".\r\n", 3 ));

      if ( read.put_string( "u\n" ))
      {
         spool.close();
         read.close();
         remove_headers();
         destroy_requests_list();
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "get_requests(): %s", read.get_error());
         return 1;
      }

      ++total_messages_transferred;
   }
      
   spool.close();
   read.close();

   remove_headers();

   destroy_requests_list();

   return 0;
}
