#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npnews.h"

int NP_News::get_message_data( int begin, int end,
                               NP_File& spool, NP_File& read )
{
   char buffer[ 4096 ];

   for( int i = begin; i <= end; ++i )
   {
      if ( get_string( buffer, sizeof buffer ))
         return 1;

      if ( stop )
      {
         strcpy( error_message, "NP_News: get_message_data(): killed by"
                 " SIGTERM." );
         return 1;
      }
      
      int result = check_response( buffer );
      switch( result )
      {
      case 0:
         break;

      case 1:
         return result;
         break;

      case 2:
         continue;
         break;
      }

      if ( head )
      {
         char buffer[ 1024 ];
         snprintf( buffer, sizeof buffer, "@header of article %d\r\n", i );
         if ( spool.put_string( buffer ))
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "get_message_data: %s", spool.get_error());
            return 1;
         }
      }

      do
      {
         if ( get_string( buffer, sizeof buffer ))
            return 1;

         if ( spool.put_string( buffer ))
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "get_message_data: %s", spool.get_error());
            return 1;
         }
      }
      while( strncmp( buffer, ".\r\n", 3 ));

      ++total_messages_transferred;

      if ( read.put_string( "u\n" ))
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "get_message_data: %s", spool.get_error());
         return 1;
      }
   }

   return 0;
}
