#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npfile.h"
#include "nptext.h"

void export_buttons_callback( GtkWidget *widget, gpointer data )
{
   GtkWidget *fs = ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget ),
                                                      "fs" );

   if ( !( int)data )
   {
      gtk_widget_destroy( fs );
      return;
   }

   NP_Text *text = ( NP_Text *)data;

   char *filename =
      gtk_file_selection_get_filename( GTK_FILE_SELECTION( fs ));

   if ( filename == NULL || *filename == '\0' )
      return;

   NP_File file;
   char buffer[ 1024 ];
   if ( file.openw( filename ))
   {
      snprintf( buffer, sizeof buffer, file.get_error());
      text->show_message( buffer );

      while( text->message_window != NULL )
         while( gtk_events_pending() )
            gtk_main_iteration();
      
      return;
   }

   char *pointer = text->text;
   if ( *pointer == '@' )
      pointer += strcspn( pointer, "\n" ) + 1;

   while( *pointer )
   {
      int idx = strcspn( pointer, "\r" );
      pointer[ idx ] = '\n';
      pointer[ ++idx ] = '\0';

      if ( file.put_string( pointer ))
      {
         file.print_error();
         return;
      }

      pointer += idx + 1;
   }

   file.close();

   snprintf( buffer, sizeof buffer, "Message text succesfully saved as %s.",
             filename );
   text->show_message( buffer );

   while( text->message_window != NULL )
      while( gtk_events_pending() )
         gtk_main_iteration();
   
   gtk_widget_destroy( fs );
   
   return;
}

void export_callback( GtkWidget *widget, gpointer data )
{
   NP_Text *text = ( NP_Text *)data;

   if ( text->offset == -1 )
   {
      text->show_message( "There is no message currently loaded." );
      return;
   }

   GtkWidget *fs = gtk_file_selection_new( "Enter Filename" );
   gtk_file_selection_set_filename( GTK_FILE_SELECTION( fs ), "export.txt" );
   gtk_object_set_data( GTK_OBJECT( GTK_FILE_SELECTION( fs )->ok_button ),
                        "fs", fs );
   gtk_object_set_data( GTK_OBJECT( GTK_FILE_SELECTION( fs )->cancel_button ),
                        "fs", fs );
                        
   gtk_signal_connect( GTK_OBJECT( GTK_FILE_SELECTION( fs )->ok_button ),
                       "clicked",
                       GTK_SIGNAL_FUNC( export_buttons_callback ), text );
   gtk_signal_connect( GTK_OBJECT( GTK_FILE_SELECTION( fs )->cancel_button ),
                       "clicked",
                       GTK_SIGNAL_FUNC( export_buttons_callback ),
                       ( gpointer )0 );

   gtk_widget_show( fs );   

   return;
}
