#include "npsummary.h"

np_thread_node_t *NP_Summary::recursively_ascend_forward(
   np_thread_node_t *current_node )
{
   np_thread_node_t *pointer = current_node;

   if ( pointer->child_next != NULL )
      pointer = pointer->child_next;
   else
      if ( pointer->parent != NULL )
         return recursively_ascend_forward( pointer->parent );
      else
         while(( pointer = pointer->next ) != NULL )
            if ( !pointer->is_child && pointer->item != NULL )
               break;

   return pointer;
}

np_thread_node_t *right_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   if ( !summary->total || summary->tree == NULL )
      return NULL;

   if ( summary->current_node == NULL || summary->selected_item == NULL )
   {
      gtk_tree_select_child( GTK_TREE( summary->tree_widget ),
                             GTK_WIDGET( summary->tree->item ));
   }

   summary->button = 1;

   np_thread_node_t *pointer;
   
   if ( summary->current_node->child_count )
   {
      if ( widget != NULL )
         gtk_tree_item_expand( GTK_TREE_ITEM( summary->selected_item ));
      pointer = summary->current_node->child_head;
   }
   else
      if ( summary->current_node->child_next != NULL )
         pointer = summary->current_node->child_next;
      else
         if ( summary->current_node->parent != NULL )
            pointer =
               summary->recursively_ascend_forward(
                  summary->current_node->parent );
         else
            if ( summary->current_node->next != NULL )
            {
               for( pointer = summary->current_node->next;
                    pointer != NULL;
                    pointer = pointer->next )
                  if ( !pointer->is_child && pointer->item != NULL )
                     break;
            }
            else
               pointer = NULL;

   if ( pointer == NULL )
   {
      summary->button = 0;
      return NULL;
   }

   if ( widget != NULL && pointer->item != NULL )
      gtk_tree_select_child( GTK_TREE( summary->tree_widget ),
                             GTK_WIDGET( pointer->item ));

   summary->button = 0;

   return pointer;
}
