#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "npthreads.h"

int compare( const void *a, const void *b )
{
   char *a_pointer;

   a_pointer = *( char **)a;
   while( *a_pointer == '"' || *a_pointer == '\'' || *a_pointer == '(' )
      ++a_pointer;

   if ( !strncasecmp( a_pointer, "Re:", 3 ))
      a_pointer += 3;

   a_pointer += strspn( a_pointer, " \t" );

   char *b_pointer;

   b_pointer = *( char **)b;
   while( *b_pointer == '"' || *b_pointer == '\'' || *b_pointer == '(' )
      ++b_pointer;

   if ( !strncasecmp( b_pointer, "Re:", 3 ))
      b_pointer += 3;

   b_pointer += strspn( b_pointer, " \t" );

   return strcasecmp( a_pointer, b_pointer );
}

int NP_Threads::sort()
{
   if ( total < 2 )
      return 0;

   struct array_t
   {
      char *subject;
      np_thread_node_t *node;
   }
   *pointer, *array;

   if (( array = ( array_t *)calloc( total, sizeof *array )) == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   pointer = array;
   np_thread_node_t *nodes = threads;

   for( int i = 0; i < total; ++i )
   {
      if (( pointer->subject = strdup( nodes->subject )) == NULL )
      {
         perror( "strdup" );
         exit( 1 );
      }
      pointer->node = nodes;
      ++pointer;

      nodes = nodes->next;
   }

   qsort( array, total, sizeof *array, compare );

   pointer = array;
   nodes = pointer->node;
   nodes->prev = NULL;
   nodes->next = ( pointer + 1 )->node;
   ++pointer;

   for( int i = 1; i < total; ++i )
   {
      np_thread_node_t *node_pointer = pointer->node;
      node_pointer->prev = ( pointer - 1 )->node;

      if ( i == total - 1 )
         node_pointer->next = NULL;
      else
         node_pointer->next = ( pointer + 1 )->node;

      ++pointer;
   }

   threads = nodes;

   return 0;
}
