#include <unistd.h>

#include <X11/Xlib.h>
#include <gdk/gdkx.h>

#include "npsummary.h"

void compose_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   if ( summary->compose_pid )
      return;

   if ( !strcmp( summary->group, "FOLLOW-UPS" ) ||
        !strcmp( summary->group, "OUTBOX" ) ||
        !strcmp( summary->group, "POSTED" ) ||
        !strcmp( summary->group, "SENT-MAIL" ))
   {
      summary->show_message( "You cannot create articles for this group." );
      return;
   }

   if ( !strcmp( summary->server, "Folders" ))
   {
      summary->show_message( "You cannot create articles in "
                             "the Folders tree.\nMessages are moved into"
                             " Folders using the \"file\" button." );
      return;
   }

   switch( summary->compose_pid = fork() )
   {
   case -1:
      perror( "fork" );
      return;
      break;

   case 0:
      close( ConnectionNumber( gdk_display ));

      execlp( "npcompose", "npcompose", summary->server, summary->group,
              "original", "-1", NULL );
      perror( "execlp" );
      _exit( 1 );
      break;

   default:

      char buffer[ 128 ];
      snprintf( buffer, sizeof buffer, "%d", summary->compose_pid );
      if ( summary->children.add_item( buffer ))
         summary->children.print_error();

      break;
   }

   return;
}
