#include <stdio.h>
#include <stdlib.h>
#include <regex.h>
#include <string.h>

#include "npfile.h"
#include "npsearch.h"

int NP_Search::compile( char *regexp )
{
   if ( regexp == NULL )
   {
      strcpy( error_message, "NP_Search: compile(): NULL regular expression"
              " argument." );
      return 1;
   }

   if ( compiled )
      regfree( &regex );
   
   int result = regcomp( &regex, regexp, REG_EXTENDED );
   if ( result )
   {
      strcpy( error_message, "NP_Search: compile(): " );
      char buffer[ 256 ];
      regerror( result, &regex, buffer, sizeof buffer );
      strcat( error_message, buffer );
      return 1;
   }

   compiled = 1;
   return 0;
}

