#include <unistd.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npsubscription.h"

int NP_Subscription::save()
{
   if ( !total )
   {
      char buffer[ 1024 ];
      snprintf( buffer, sizeof buffer, "%s/.peruser4-newsrc", home );
      truncate( buffer, 0 );
      return 0;
   }
   
   if ( newsrc_file.openw( newsrc_path ))
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "save(): %s", newsrc_file.get_error() );
      return 1;
   }

   char buffer[ 1024 ];

   group_list_t *pointer = group_list;
   for( int i = 0; i < total; ++i )
   {
      snprintf( buffer, sizeof buffer, "%s\n", server_names[ i ] );
      
      if ( newsrc_file.put_string( buffer ))
      {
         snprintf( error_message, sizeof error_message, "NP_Subscription: "
                   "save(): %s", newsrc_file.get_error() );
         newsrc_file.close();
         return 1;
      }

      int j = pointer->group_names->get_total();

      if ( !j )
         continue;
      
      for( int k = 0; k < j; ++k )
      {
         const char *group = ( *pointer->group_names )[ k ];
         if ( group == NULL )
         {
            ( *pointer->group_names ).print_error();
            return 1;
         }

         const char *article = ( *pointer->article_nos )[ k ];
         if ( article == NULL )
         {
            ( *pointer->article_nos ).print_error();
            return 1;
         }

         snprintf( buffer, sizeof buffer, "\t%s: %s\n", group, article );
         
         if ( newsrc_file.put_string( buffer ) )
         {
            newsrc_file.print_error();
            newsrc_file.close();
            
            return 1;
         }
      }

      ++pointer;
   }
   
   newsrc_file.close();

   if ( authentication.save())
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "save(): %s", authentication.get_error() );
   
   return 0;
}
